<?php

namespace Drupal\es_filter_analyser;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\search_api\IndexInterface;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Helpers for EventSubscribers.
 */
abstract class EventSubscriberBase implements EventSubscriberInterface {


  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * Constructs a FunctionScoreQuerySubscriber object.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager.
   */
  public function __construct(EntityTypeManagerInterface $entity_type_manager) {
    $this->entityTypeManager = $entity_type_manager;
  }

  /**
   * Load processor config.
   *
   * @param \Drupal\search_api\IndexInterface $index
   *   Index inpacted.
   * @param string $processor_name
   *   Processor Search.
   *
   * @return array|null
   *   Return processor config or null.
   */
  protected function getProcessorSettings(IndexInterface $index, $processor_name) {

    try {
      if (!$index) {
        return NULL;
      }

      // Check if processor es_function_score_query_processor est used.
      if (!$index->isValidProcessor($processor_name)) {
        return NULL;
      }

      $processor = $index->getProcessor($processor_name);
      if (!$processor) {
        return NULL;
      }

      // Get function_score config entity.
      return $processor->getConfiguration();

    }
    catch (\Exception $e) {
      // Rise an error if something wrong.
      \Drupal::logger('es_filter_analyser')->error('Error when searching @processor in index : @message', [
        '@processor' => $processor_name,
        '@message' => $e->getMessage(),
      ]);
      return NULL;
    }

  }

}
