<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides an Apostrophe filter type.
 *
 * @FilterType(
 *   id = "apostrophe",
 *   label = @Translation("Apostrophe"),
 *   description = @Translation("Removes apostrophes and characters following them.")
 * )
 */
class Apostrophe extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $form['info'] = [
      '#markup' => $this->t('This filter has no configuration options. It removes apostrophes and all characters after them (e.g., "O\'Neil" becomes "O").'),
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    return [];
  }

}
