<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides an ASCII Folding filter type.
 *
 * @FilterType(
 *   id = "asciifolding",
 *   label = @Translation("ASCII Folding"),
 *   description = @Translation("Converts alphabetic, numeric, and symbolic Unicode characters to their ASCII equivalents.")
 * )
 */
class AsciiFolding extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'preserve_original' => FALSE,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $configuration += $this->defaultConfiguration();

    $form['preserve_original'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Preserve original'),
      '#default_value' => $configuration['preserve_original'],
      '#description' => $this->t('If checked, keeps both the original and folded tokens.'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    return [
      'preserve_original' => (bool) $values['preserve_original'],
    ];
  }

}
