<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides an Elision filter type.
 *
 * @FilterType(
 *   id = "elision",
 *   label = @Translation("Elision"),
 *   description = @Translation("Removes elisions from tokens.")
 * )
 */
class Elision extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'articles' => ['l', 'd', 'm', 't', 'qu', 'n', 's', 'j', 'c'],
      'articles_case' => TRUE,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $configuration += $this->defaultConfiguration();

    $form['articles'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Articles'),
      '#default_value' => implode("\n", $configuration['articles']),
      '#description' => $this->t('Enter one article per line (e.g., l, d, m, t, qu).'),
      '#required' => TRUE,
      '#rows' => 5,
    ];

    $form['articles_case'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Case sensitive'),
      '#default_value' => $configuration['articles_case'],
      '#description' => $this->t('If checked, articles matching is case-sensitive.'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {

    $articles = $values['articles'];
    $articles_array = array_filter(array_map('trim', explode("\n", $articles)));

    return [
      'articles' => array_values($articles_array),
      'articles_case' => (bool) $values['articles_case'],
    ];
  }

}
