<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Limit filter type.
 *
 * @FilterType(
 *   id = "limit",
 *   label = @Translation("Limit"),
 *   description = @Translation("Limits the number of tokens per field.")
 * )
 */
class Limit extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'max_token_count' => 1,
      'consume_all_tokens' => FALSE,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $configuration += $this->defaultConfiguration();

    $form['max_token_count'] = [
      '#type' => 'number',
      '#title' => $this->t('Maximum token count'),
      '#default_value' => $configuration['max_token_count'],
      '#description' => $this->t('Maximum number of tokens to output.'),
      '#required' => TRUE,
      '#min' => 1,
    ];

    $form['consume_all_tokens'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Consume all tokens'),
      '#default_value' => $configuration['consume_all_tokens'],
      '#description' => $this->t('If checked, the filter consumes all tokens even if the limit is reached.'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    return [
      'max_token_count' => (int) $values['max_token_count'],
      'consume_all_tokens' => (bool) $values['consume_all_tokens'],
    ];
  }

}
