<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Snowball filter type.
 *
 * @FilterType(
 *   id = "snowball",
 *   label = @Translation("Snowball"),
 *   description = @Translation("Uses Snowball-generated stemmers for multiple languages.")
 * )
 */
class Snowball extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'language' => 'English',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $configuration += $this->defaultConfiguration();

    $form['language'] = [
      '#type' => 'select',
      '#title' => $this->t('Language'),
      '#default_value' => $configuration['language'],
      '#options' => [
        'Arabic' => $this->t('Arabic'),
        'Armenian' => $this->t('Armenian'),
        'Basque' => $this->t('Basque'),
        'Catalan' => $this->t('Catalan'),
        'Danish' => $this->t('Danish'),
        'Dutch' => $this->t('Dutch'),
        'English' => $this->t('English'),
        'Finnish' => $this->t('Finnish'),
        'French' => $this->t('French'),
        'German' => $this->t('German'),
        'German2' => $this->t('German2'),
        'Hungarian' => $this->t('Hungarian'),
        'Irish' => $this->t('Irish'),
        'Italian' => $this->t('Italian'),
        'Kp' => $this->t('Kp'),
        'Lithuanian' => $this->t('Lithuanian'),
        'Lovins' => $this->t('Lovins'),
        'Norwegian' => $this->t('Norwegian'),
        'Porter' => $this->t('Porter'),
        'Portuguese' => $this->t('Portuguese'),
        'Romanian' => $this->t('Romanian'),
        'Russian' => $this->t('Russian'),
        'Spanish' => $this->t('Spanish'),
        'Swedish' => $this->t('Swedish'),
        'Turkish' => $this->t('Turkish'),
      ],
      '#required' => TRUE,
      '#description' => $this->t('Select the language for Snowball stemming.'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    return [
      'language' => $values['language'],
    ];
  }

}
