<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Stemmer Override filter type.
 *
 * @FilterType(
 *   id = "stemmer_override",
 *   label = @Translation("Stemmer Override"),
 *   description = @Translation("Overrides stemming algorithms with custom rules.")
 * )
 */
class StemmerOverride extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'rules' => [],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $configuration += $this->defaultConfiguration();

    $form['rules'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Stemming rules'),
      '#default_value' => implode("\n", $configuration['rules']),
      '#description' => $this->t('Enter one rule per line in the format: word => stem (e.g., "running => run").'),
      '#required' => TRUE,
      '#rows' => 10,
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    $rules = $values['rules'];
    $rules_array = array_filter(array_map('trim', explode("\n", $rules)));

    return [
      'rules' => array_values($rules_array),
    ];
  }

}
