<?php

namespace Drupal\es_filter_analyser\Plugin\FilterType;

use Drupal\es_filter_analyser\Plugin\FilterTypeBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a Trim filter type.
 *
 * @FilterType(
 *   id = "trim",
 *   label = @Translation("Trim"),
 *   description = @Translation("Removes leading and trailing whitespace from tokens.")
 * )
 */
class Trim extends FilterTypeBase {

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []) {
    $form['info'] = [
      '#markup' => $this->t('This filter has no configuration options. It removes whitespace from the beginning and end of tokens.'),
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array $values) {
    return [];
  }

}
