<?php

namespace Drupal\es_filter_analyser\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Form\FormStateInterface;

/**
 * Defines an interface for Filter Type plugins.
 */
interface FilterTypeInterface extends PluginInspectionInterface {

  /**
   * Returns the filter type label.
   *
   * @return string
   *   The filter type label.
   */
  public function label();

  /**
   * Returns the filter type description.
   *
   * @return string
   *   The filter type description.
   */
  public function description();

  /**
   * Builds the configuration form for this filter type.
   *
   * @param array $form
   *   The form array.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state.
   * @param array $configuration
   *   The current configuration.
   *
   * @return array
   *   The form array.
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state, array $configuration = []);

  /**
   * Validates the configuration form.
   *
   * @param array $form
   *   The form array.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state.
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state);

  /**
   * Submits the configuration form.
   *
   * @param array $values
   *   The form form_state settings section.
   *
   * @return array
   *   The configuration array.
   */
  public function submitConfigurationForm(array $values);

  /**
   * Gets the default configuration for this filter type.
   *
   * @return array
   *   The default configuration.
   */
  public function defaultConfiguration();

}
