<?php

namespace Drupal\es_filter_analyser\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Provides a FilterType plugin manager.
 */
class FilterTypeManager extends DefaultPluginManager {

  /**
   * Constructs a FilterTypeManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/FilterType',
      $namespaces,
      $module_handler,
      'Drupal\es_filter_analyser\Plugin\FilterTypeInterface',
      'Drupal\es_filter_analyser\Annotation\FilterType'
    );
    $this->alterInfo('filter_type_info');
    $this->setCacheBackend($cache_backend, 'filter_type_plugins');
  }

  /**
   * Gets filter type options for a select list.
   *
   * @return array
   *   An array of filter type options.
   */
  public function getFilterTypeOptions() {
    $options = [];
    foreach ($this->getDefinitions() as $plugin_id => $definition) {
      $options[$plugin_id] = $definition['label'];
    }
    return $options;
  }

}
