<?php

namespace Drupal\event_group;

use Drupal\Core\Config\Entity\ConfigEntityStorageInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\group\Entity\Storage\GroupRelationshipTypeStorageInterface;
use Drupal\group\Plugin\Group\Relation\GroupRelationTypeManagerInterface;

class EventGroupRelationHelper implements EventGroupRelationHelperInterface {

  protected ConfigEntityStorageInterface $groupTypeStorage;

  protected GroupRelationshipTypeStorageInterface $groupRelationshipTypeStorage;

  protected GroupRelationTypeManagerInterface $groupRelationTypeManager;

  public function __construct(EntityTypeManagerInterface $entity_type_manager, GroupRelationTypeManagerInterface $group_relation_type_manager) {
    $this->groupTypeStorage = $entity_type_manager->getStorage('group_type');
    $this->groupRelationshipTypeStorage = $entity_type_manager->getStorage('group_relationship_type');
    $this->groupRelationTypeManager = $group_relation_type_manager;
  }

  public function createEventGroupRelationshipType(): void {
    // Only work on the event group.
    $group_type = $this->groupTypeStorage->load('events');

    // If we're looking at a specific group, return if its not event.
    if (!isset($group_type)) {
      return;
    }

    $plugin_id = 'event_group';
    $installed = $this->groupRelationTypeManager->getInstalledIds($group_type);
    if (!in_array($plugin_id, $installed)) {
      $this->groupRelationshipTypeStorage
        ->createFromPlugin($group_type, $plugin_id)
        ->save();
    }
  }
}
