## CONTENTS OF THIS FILE

- Introduction
- Requirements
- Installation
- Development
- Maintainers


## INTRODUCTION

The Event Horizon theme is a FLDC forked project extended and configured for the event platform.

Goals:

- An easy out of the box and modern experience for a camp or event website.
- A stable, maintainable, and tested integration with the event platform suite.
- A pluggable/extensible theme that highlights the event platform features.

Demo:

- Video review of the Event Horizon theme:
  TODO

## REQUIREMENTS

This theme is made to compliment the events platform.


## INSTALLATION

1. If your site is [managed via Composer](https://www.drupal.org/node/2718229),
   use Composer to download the webform module running
   ```composer require "drupal/event_horizon"```. Otherwise copy/upload the event_horizon
   theme to the custom themes directory of your Drupal installation.

2. Enable the 'Event horizon' theme and desired sub-modules in 'Appearance'.
   (`admin/appearance`)

3. Set up user permissions. (`/admin/people/permissions#module-webform`)


## DEVELOPMENT

SCSS asset are compiled both globaly and per SDC component.
All scss assets override css files. Changes should happen on the SCSS files.

```
cd /web/themes/custom/event_horizon
ddev yarn install
ddev yarn gulp compile-component-directory-sass
ddev yarn gulp compile-sass-directory-sass
```

There are two scss locations. The global one located under event_horizon/sass and the local one to each component.

```
ddev yarn gulp clean:css-directory-css
ddev yarn gulp clean:component-directory-css

```

The two cleanup commands help with clearing all those files.



## MAINTAINERS

- Martin Anderson-Clutz (mandclu) - https://www.drupal.org/u/mandclu
- Bernardo Martinez (bernardm28) -  https://www.drupal.org/u/bernardm28

