/**
 * @file
 * Add a class to event dates in the past.
 */

((Drupal, once) => {
  function init(el) {
    const keyDate = new Date(el.getAttribute('datetime'));
    const currentDate = new Date();
    if (currentDate > keyDate) {
      el.classList.add('past-date');
    }
  }

  Drupal.behaviors.eventDates = {
    attach(context) {
      once('event-dates', '.block-views-blockevent-dates-block-1 time', context).forEach(init);
    },
  };
})(Drupal, once);
