<?php

declare(strict_types=1);

namespace Drupal\event_platform_mcp\Repository;

/**
 * Interface for configuration-related database operations.
 */
interface ConfigRepositoryInterface {

  /**
   * Get event details from config pages.
   *
   * @return array|null
   *   Event details array or NULL if not found.
   */
  public function getEventDetails(): ?array;

  /**
   * Get event date range.
   *
   * @return array|null
   *   Array with 'start' and 'end' keys or NULL if not found.
   */
  public function getEventDateRange(): ?array;

  /**
   * Find user ID by display name.
   *
   * @param string $name
   *   The user display name.
   *
   * @return string|null
   *   The user ID or NULL if not found.
   */
  public function findUserIdByName(string $name): ?string;

}
