<?php

declare(strict_types=1);

namespace Drupal\event_platform_mcp\Repository;

/**
 * Interface for taxonomy-related database operations.
 */
interface TaxonomyRepositoryInterface {

  /**
   * Get terms by vocabulary.
   *
   * @param string $vocabulary
   *   The vocabulary machine name.
   *
   * @return \Drupal\taxonomy\TermInterface[]
   *   Array of taxonomy terms.
   */
  public function getTermsByVocabulary(string $vocabulary): array;

  /**
   * Find term ID by name and vocabulary.
   *
   * @param string $vocabulary
   *   The vocabulary machine name.
   * @param string $name
   *   The term name.
   *
   * @return string|null
   *   The term ID or NULL if not found.
   */
  public function findTermIdByName(string $vocabulary, string $name): ?string;

  /**
   * Get time slots by date.
   *
   * @param string $date
   *   The date in Y-m-d format.
   *
   * @return string[]
   *   Array of time slot IDs.
   */
  public function getTimeSlotsByDate(string $date): array;

  /**
   * Get time slots by date range.
   *
   * @param string $startDate
   *   The start date in Y-m-d format.
   * @param string $endDate
   *   The end date in Y-m-d format.
   *
   * @return string[]
   *   Array of time slot IDs.
   */
  public function getTimeSlotsByDateRange(string $startDate, string $endDate): array;

  /**
   * Get all time slots.
   *
   * @return \Drupal\taxonomy\TermInterface[]
   *   Array of time slot terms.
   */
  public function getAllTimeSlots(): array;

}
