<?php

declare(strict_types=1);

namespace Drupal\event_platform_mcp\Repository;

use Drupal\node\NodeInterface;

/**
 * Interface for event-related database operations.
 */
interface EventRepositoryInterface {

  /**
   * Get sessions for a specific time slot.
   *
   * @param string $timeSlotId
   *   The time slot ID.
   * @param array $contentTypes
   *   Array of content types to include.
   *
   * @return \Drupal\node\NodeInterface[]
   *   Array of session nodes.
   */
  public function getSessionsForTimeSlot(string $timeSlotId, array $contentTypes = ['session', 'special_session']): array;

  /**
   * Search sessions with filters.
   *
   * @param array $filters
   *   Array of filters to apply.
   * @param int $limit
   *   Maximum number of results.
   * @param int $offset
   *   Offset for pagination.
   *
   * @return \Drupal\node\NodeInterface[]
   *   Array of session nodes.
   */
  public function searchSessions(array $filters = [], int $limit = 50, int $offset = 0): array;

  /**
   * Get a session by ID.
   *
   * @param string $sessionId
   *   The session ID.
   * @param array $contentTypes
   *   Array of content types to include.
   *
   * @return \Drupal\node\NodeInterface|null
   *   The session node or NULL if not found.
   */
  public function getSessionById(string $sessionId, array $contentTypes = ['session', 'special_session']): ?NodeInterface;

  /**
   * Get all speakers from sessions.
   *
   * @return array
   *   Array of speaker names.
   */
  public function getAllSpeakers(): array;

}
