# Event to Calendar Module

## Author
**Kunal Sahu**

## Overview
The **Event to Calendar** module allows users to easily add events to various calendar platforms directly from a Drupal website. This module provides functionality to generate `.ics`, `.vcs`, and `.csv` files for events and create links for Google Calendar, Outlook Calendar, Yahoo Calendar, and an RSS feed for upcoming events.

## Features
- **Generate iCalendar (.ics) Files**: Users can download event details in `.ics` format.
- **Generate vCalendar (.vcs) Files**: Users can download event details in `.vcs` format.
- **Generate CSV Files**: Users can download event details in `.csv` format for easy import into spreadsheet applications.
- **Google Calendar Integration**: Create links to add events directly to Google Calendar.
- **Outlook Calendar Integration**: Create links to add events directly to Outlook Calendar.
- **Yahoo Calendar Integration**: Create links to add events directly to Yahoo Calendar.
- **RSS Feed for Upcoming Events**: Generate an RSS feed that lists upcoming events.

## Usage
1. Install the module by placing it in the `/modules/custom` directory.
2. Enable the module using Drush or the Drupal admin interface.
3. Configure the settings under **Admin > Configuration > Web Services > Event to Calendar**.
4. Add the calendar buttons to your event content type using the provided Twig template.

## Known Issues
Currently, the JavaScript and CSS files are not being loaded or executed as expected. This issue needs to be resolved to ensure that the modal functionality and styles work correctly.

## Future Improvements
- Debug and resolve the JavaScript and CSS loading issue.
- Implement additional calendar platforms as needed.
- Enhance the user interface for better usability.

## Contributing
If you would like to contribute to this module, please submit a pull request or open an issue on the repository.

## License
This module is licensed under the MIT License.
