<?php

namespace Drupal\exact_online\Service;

/**
 * Interface for the Exact Online service.
 */
interface ExactOnlineServiceInterface {

  /**
   * Gets the authorization URL for OAuth flow.
   *
   * @return string
   *   The authorization URL.
   */
  public function getAuthorizationUrl(): string;

  /**
   * Handles the OAuth callback and token storage.
   *
   * @return bool
   *   TRUE if successful, FALSE otherwise.
   */
  public function handleCallback(): bool;

  /**
   * Gets the current connection status.
   *
   * @return bool
   *   TRUE if connected, FALSE otherwise.
   */
  public function getConnectionStatus(): bool;

  /**
   * Gets the company information.
   *
   * @return array
   *   Array containing company information.
   */
  public function getCompanyInfo(): array;

  /**
   * Gets the recent logs.
   *
   * @param int $limit
   *   Number of logs to return.
   *
   * @return array
   *   Array of recent log entries.
   */
  public function getRecentLogs(int $limit = 10): array;

  /**
   * Gets all logs with optional filtering.
   *
   * @param array $filters
   *   Array of filter criteria.
   *
   * @return array
   *   Array of log entries.
   */
  public function getLogs(array $filters = []): array;

}
