Exchange Rate
=============

The **Exchange Rate** module provides functionality for fetching, displaying, and converting real-time currency exchange rates using the [ExchangeRate-API](https://app.exchangerate-api.com/). It allows site administrators to add a fully customizable **Exchange Rate Block** showing live rates for multiple currencies and countries, along with a **Currency Conversion Block** that enables users to convert amounts from a selected base currency or country to multiple target currencies instantly.

This module offers **flexible layout options**, optional base currency display,
country selection and ordering, description text, and caching controls to
optimize API requests. Administrators can also override Twig templates and apply
custom CSS and JavaScript for a tailored user experience.

Ideal for **financial websites, e-commerce platforms, reporting dashboards,
travel or banking portals**, the Exchange Rate module ensures users always
have accurate and up-to-date currency information. The integrated conversion
form makes it easy for visitors to calculate real-time equivalents across
multiple currencies in one action, improving user engagement and site
functionality.

* * *

Table of contents
-----------------

*   Requirements
*   Installation
*   API Key Setup
*   Configuration
*   Blocks Provided
*   Hooks
*   Services
*   Caching
*   Customization
*   Troubleshooting
*   Maintainers

* * *

Requirements
------------

This module requires only Drupal core.

* * *

Installation
------------

Install as you would normally install a contributed Drupal module. For more
information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

If using Composer:

    composer require drupal/exchangerate

Enable the module using Drush:

    drush en exchangerate

API Key Setup
-------------

To fetch exchange rates, the module requires a valid API key from
[ExchangeRate-API](https://www.exchangerate-api.com/). You can also configure caching
to reduce API calls and improve performance. Follow these steps:

1.  Sign up at [ExchangeRate-API](https://www.exchangerate-api.com/) and obtain your API key.
2.  Go to: `Configuration → System → Exchange Rate Settings`.
3.  Enter your \*\*API Key\*\* in the provided field.
4.  Select your \*\*Base Currency\*\* (default: USD).
5.  Configure caching options:
    *   **Enable Cache:** Toggle caching on or off.
    *   **Cache Duration:** Enter a numeric value for how long to cache
    rates (default: 1).
    *   **Cache Unit:** Choose minutes or hours for the duration.
6.  Save the configuration.

**How caching works:**

*   When enabled, the module stores the latest exchange rates in Drupal's
cache system.
*   The cached data is valid for the duration you set. During this time,
API calls are avoided, which improves performance and reduces external
requests.
*   Once the cache expires, the module fetches fresh rates from the API
and stores them again in the cache.
*   If caching is disabled, the module fetches live rates from the API
on every page load.

Proper cache configuration ensures up-to-date exchange rates while minimizing
unnecessary API requests and improving site performance.


* * *

Configuration
-------------

### Exchange Rate Block

1.  Go to: `Structure → Block layout → Place block`.
2.  Place an **Exchange Rate Block** in the desired region.
3.  In the block configuration form:
    *   Enable or disable **Base Currency Display**.
    *   Enter optional **Description Text** to display above exchange rates.
    *   Select the desired **Layout** (layout-1 to layout-4).
    *   Choose and order **Countries** to display. Drag rows to set the order.
    *   Set **Cache Duration** and **Cache Unit** (minutes or hours) for
    API calls.
4.  Save the block configuration.

The block will render immediately with exchange rates and selected
configurations.

### Currency Conversion Block

1.  Go to: `Structure → Block layout → Place block`.
2.  Place a **Currency Conversion Block** in the desired region.
3.  Save the block configuration.

The block will render a form allowing users to enter an amount, submit it,
and view live conversion results from the selected currency or country
to multiple target currencies.

* * *

Blocks Provided
---------------

*   **Exchange Rate Block** – Displays live exchange rates for selected
countries and base currency.
*   **Currency Converter Block** – Provides a form to convert amounts
between currencies.

* * *

Hooks
-----

The module provides the following hook for extensibility:

*   `hook_exchangerate_countries_alter(array &$countries)` – Allows
other modules to add, modify, or remove countries from the list.

* * *

Services
--------

The module defines the following service:

*   `exchangerate.api` – Fetches and caches exchange rate data,
provides base currency and countries list.

* * *

Caching
-------

Exchange rates are cached to minimize API calls. The caching options include:

*   Enable/disable cache in block configuration.
*   Set cache duration (default: 1 hour) and unit (minutes or hours).
*   Cached data expires automatically based on the chosen duration.

* * *

Customization
-------------

*   Override the default Twig templates: `exchangerate-block.html.twig`
and `currency-conversion-results.html.twig` in `templates/`.
*   Apply custom CSS classes for personalized styling.
*   Integrate JavaScript for advanced features like live conversions
or interactive displays.

Use standard Drupal theming practices to override templates and libraries
via your theme or a custom module.

* * *

Troubleshooting
---------------

*   Ensure the block is placed in an active region and visible.
*   Check API key validity if exchange rates do not display.
*   Verify cache settings to ensure rates are updated correctly.
*   Inspect template overrides and CSS if the layout does not display
as expected.

* * *

Maintainers
-----------

*   Sujan Shrestha - [sujan-shrestha](https://www.drupal.org/u/sujan-shrestha)
