<?php

/**
 * @file
 * Hooks provided by the Exchangerate module.
 */

/**
 * Alter the list of countries in Exchangerate.
 *
 * Other modules may implement this hook to add, remove, or modify
 * country definitions used by the Exchangerate module.
 *
 * @param array $countries
 *   An associative array of countries keyed by currency code.
 *   Each country definition contains:
 *   - name: The country name (string).
 *   - currency_code: The currency code (string).
 *   - currency_symbol: The currency symbol (string).
 *   - flag_emoji: The flag emoji (string).
 *
 * @code
 *   Example: Add a new country
 *   $countries['USD'] = [
 *     'name' => t('United States of America'),
 *     'currency_code' => 'USD',
 *     'currency_symbol' => '$',
 *     'flag_emoji' => '🇺🇸',
 *   ];
 *
 *   Example: Modify an existing country
 *   if (isset($countries['BRL'])) {
 *     $countries['BRL']['currency_symbol'] = 'BRL$';
 *   }
 *
 *   Example: Remove a country
 *   unset($countries['ALL']);
 *
 *   Example usage in a custom module:
 *   function my_module_exchangerate_countries_alter(array &$countries) {
 *     // Add United States of America.
 *     $countries['USD'] = [
 *       'name' => t('United States of America'),
 *       'currency_code' => 'USD',
 *       'currency_symbol' => '$',
 *       'flag_emoji' => '🇺🇸',
 *     ];
 *
 *     // Modify Brazil.
 *     if (isset($countries['BRL'])) {
 *       $countries['BRL']['currency_symbol'] = 'BRL$';
 *     }
 *
 *     // Remove Albania.
 *     unset($countries['ALL']);
 *   }
 * @endcode
 */
function hook_exchangerate_countries_alter(array &$countries) {
}
