<?php

namespace Drupal\exif_manipulate\Services;

use Drupal\file\FileInterface;

/**
 * Class FileProcessorInterface processes EXIF data for files.
 */
interface FileExifProcessorInterface {

  /**
   * Manipulate EXIF file data.
   *
   * @param \Drupal\file\FileInterface $file
   *   The file entity.
   *
   * @throws \lsolesen\pel\PelException
   *   The operations in the method may throw a PelException when there is
   *   anything wrong with the Exif data. The calling code needs to take
   *   appropriate action.
   */
  public function manipulate(FileInterface $file): void;

}
