<?php

declare(strict_types=1);

namespace Drupal\Tests\exif_manipulate\Functional;

use lsolesen\pel\PelJpeg;
use lsolesen\pel\PelTag;

/**
 * Trait to assert images was cleaned for use in tests.
 */
trait ImageAssertionTrait {

  // phpcs:disable Drupal.Commenting.FunctionComment.Missing,Squiz.WhiteSpace.FunctionSpacing.After,Drupal.Commenting.FunctionComment.WrongStyle
  // Add abstract copies of the methods from BrowserTestBase.
  abstract public static function assertNotNull($actual, string $message = ''): void;
  abstract public static function assertContains($needle, \Traversable|array $haystack, string $message = ''): void;
  abstract public static function fail(string $message = ''): void;
  // phpcs:enable

  /**
   * Verify that an image no longer contains any EXIF data except orientation.
   */
  private function assertImageIsClean($file) {
    $pelFile = new PelJpeg($file->getFileUri());

    $exif = $pelFile->getExif();
    $this->assertNotNull($exif, 'The image has EXIF data.');
    $tiff = $exif->getTiff();
    $this->assertNotNull($tiff, 'There is a TIFF object in the EXIF data.');
    $ifd = $tiff->getIfd();
    $this->assertNotNull($ifd, 'There is an Image File Directory object in the TIFF data.');
    $tagsFound = [];
    $pelTagReflection = new \ReflectionClass(PelTag::class);
    $tagsAvailable = $pelTagReflection->getConstants();

    do {
      foreach ($tagsAvailable as $tag) {
        $entry = $ifd->getEntry($tag);
        if ($entry) {
          $tagsFound[$entry->getTag()] = $ifd->getType();
        }
      }
    } while ($ifd = $ifd->getNextIfd());

    $this->assertContains(PelTag::ORIENTATION, array_keys($tagsFound), 'The image should have orientation data.');

    foreach ($tagsFound as $tag => $type) {
      if ($tag === PelTag::ORIENTATION) {
        continue;
      }
      $this->fail('The image should not have any tags other than Orientation. Found: ' . PelTag::getName($type, $tag));
    }
  }

}
