<?php

declare(strict_types=1);

namespace Drupal\experience_builder\Plugin\Field\FieldTypeOverride;

use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\experience_builder\Plugin\Validation\Constraint\StringSemanticsConstraint;
use Drupal\text\Plugin\Field\FieldType\TextItem;

/**
 * @todo Fix upstream.
 *
 * Adds StringSemantics constraint to the 'processed' property to handle rich
 * text content with proper semantic typing.
 */
class TextItemOverride extends TextItem {

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition) {
    $properties = parent::propertyDefinitions($field_definition);
    $properties['processed']
      // It is computed from the required `value` property, so this value can be
      // considered required, too.
      ->setRequired(TRUE)
      ->addConstraint('StringSemantics', StringSemanticsConstraint::MARKUP);
    // Convey to schema-matching systems like Experience Builder to deduce that
    // only `processed` contains actually relevant information for humans.
    $properties['format']->setSetting('is source for', 'processed');
    $properties['value']->setSetting('is source for', 'processed');
    return $properties;
  }

}
