# Release 1.0.2

## Initial Release

This is the initial release of Extend Help Maintainers module.

### Features

* **Plugin-based architecture** - Extensible system for fetching maintainers from multiple sources
* **Info YAML Fetcher** - Reads maintainers from module `.info.yml` files (priority: 100)
* **Drupal.org Fetcher** - Scrapes maintainers from Drupal.org project pages (priority: 10)
* **Priority-based merge strategy** - Deterministic merging with configurable priorities
* **Automatic integration** - Seamlessly adds maintainers block to help pages via `hook_help_alter()`
* **Configuration UI** - Admin form to enable/disable fetchers and configure priorities
* **Caching support** - Efficient caching with proper metadata and invalidation

### Technical

* **Full test coverage** - Unit tests for DTO and merge logic, Kernel tests for integration
* **DTO pattern** - Immutable value objects for maintainers
* **Dependency Injection** - Clean architecture with proper DI throughout
* **Security** - Input validation, XSS prevention, URL sanitization
* **Standards compliance** - PSR-12 and Drupal Coding Standards

### Documentation

* Comprehensive README with architecture overview
* PlantUML architecture diagram
* Inline code documentation
* Installation and usage instructions
* Contributing guidelines

### Requirements

* Drupal 10 or 11
* PHP 8.1+

### Installation

```bash
drush en extend_help_maintainers
```

Or install via the Extend page at `/admin/modules`.

### Configuration

Navigate to `/admin/config/system/extend-help-maintainers` to:
* Enable/disable fetcher plugins
* Configure custom priorities for each source

### Usage

Once enabled, the module automatically adds maintainers information to any module's help page if maintainers are found in:
* Module's `.info.yml` file (under `extra.extend_help_maintainers.maintainers`)
* Drupal.org project page

### Architecture

The module follows a clean, layered architecture:
* **Service layer** - MaintainersService orchestrates the workflow
* **Plugin system** - MaintainersFetcher plugins for data sources
* **Merge strategy** - MaintainersMerger handles priority-based merging
* **Builder** - MaintainersHelpBuilder creates render arrays

See `docs/architecture.puml` for detailed component diagram.

### Testing

Run tests:

```bash
# Unit tests
./vendor/bin/phpunit --testsuite=unit

# Kernel tests
./vendor/bin/phpunit --testsuite=kernel

# All tests
./vendor/bin/phpunit
```

### Credits

Developed following Drupal core quality standards and best practices.

### License

GPL-2.0-or-later

