<?php

namespace Drupal\extend_help_maintainers\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a MaintainersFetcher plugin annotation.
 *
 * Plugins annotated with @MaintainersFetcher provide a mechanism
 * for retrieving maintainers information (e.g., from .info.yml,
 * Drupal.org API, or other sources).
 *
 * Example:
 * @code
 * @MaintainersFetcher(
 *   id = "info_file",
 *   label = @Translation("Info file fetcher"),
 *   description = @Translation("Reads maintainers from a module's .info.yml file."),
 *   priority = 100
 * )
 * @endcode
 *
 * @Annotation
 */
class MaintainersFetcher extends Plugin {

  /**
   * The unique plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * Human readable label.
   *
   * @var string
   */
  public $label;

  /**
   * Optional description of the plugin.
   *
   * @var string
   */
  public $description;

  /**
   * Optional priority for sorting plugins.
   *
   * Higher values mean higher priority.
   *
   * @var int
   */
  public $priority;

}
