<?php

namespace Drupal\extend_help_maintainers\Plugin\MaintainersFetcher;

use Drupal\extend_help_maintainers\DTO\Maintainer;

/**
 * Defines the contract for MaintainersFetcher plugins.
 *
 * Implementations of this interface are responsible for retrieving
 * maintainers metadata for a given module (e.g., from .info.yml,
 * Drupal.org API, or other external sources).
 *
 * Each plugin must return an array of Maintainer DTO objects,
 * which are later merged and rendered by the service layer.
 */
interface MaintainersFetcherInterface {

  /**
   * Fetch maintainers for a module.
   *
   * @param string $module_name
   *   The machine name of the module.
   *
   * @return \Drupal\extend_help_maintainers\DTO\Maintainer[]
   *   An array of Maintainer DTO objects.
   */
  public function fetchMaintainers(string $module_name): array;

}
