# Changelog

All notable changes to this project will be documented in this file.

## [1.0.0] - 2024

### Added
- Initial release
- Plugin-based architecture for maintainer fetchers
- Support for Info YAML and Drupal.org sources
- Priority-based merge strategy
- Configurable source selection and priorities
- Full test coverage (Unit + Kernel tests)
- `hook_help_alter()` integration
- Caching support with proper metadata
- Comprehensive documentation (README, architecture diagram)
- Configuration schema
- Logger channel for this module

### Security
- Input validation for module names
- XSS prevention in templates (all output escaped)
- URL sanitization for external requests
- Proper dependency injection (no `\Drupal::service()` in classes)

### Code Quality
- PSR-12 and Drupal Coding Standards compliance
- Dependency Injection throughout
- Proper type hints and return types
- Comprehensive PHPDoc comments
- No deprecated code usage

### Architecture
- Clean separation of concerns
- SOLID principles
- Plugin-driven extensibility
- DTO pattern for maintainers
- Service-oriented design

