<?php

namespace Drupal\external\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Class ExternalAdminSettings.
 *
 * @package Drupal\external\Form
 */
class ExternalAdminSettings extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'external_admin_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['external.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('external.settings');
    $form = [];

    $form['external_enabled'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable External Module'),
      '#default_value' => $config->get('external_enabled'),
    ];
    $form['external_docs_enabled'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Open PDFs in new tabs'),
      '#default_value' => $config->get('external_docs_enabled'),
    ];
    $form['external_disabled_patterns'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Pages to exclude'),
      '#default_value' => $config->get('external_disabled_patterns'),
      '#description' => $this->t("Enter one page per line as Drupal paths. The '*' character is a wildcard. Example paths are %blog for the blog page and %blog-wildcard for every personal blog. %front is the front page.", [
        '%blog' => 'blog',
        '%blog-wildcard' => 'blog/*',
        '%front' => '<front>',
      ]),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('external.settings')
      ->set('external_enabled', $form_state->getValue('external_enabled'))
      ->set('external_docs_enabled', $form_state->getValue('external_docs_enabled'))
      ->set('external_disabled_patterns', $form_state->getValue('external_disabled_patterns'))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
