<?php

/**
 * @file
 * Test Connection.
 */
function testConnection($form, &$form_state) {
  global $user;
  if ($user->uid == 1) {
    $form['external_db_login_config_test'] = array(
        '#type' => 'fieldset',
        '#title' => t('Test Connection'),
        '#weight' => 6,
        '#collapsible' => TRUE,
        '#collapsed' => FALSE,
    );
    $form['external_db_login_config_test']['testconnection'] = array(
        '#type' => 'submit',
        '#value' => t('Test Connection'),
    );
    return $form;
  }
  else {
    drupal_access_denied();
    drupal_exit();
  }
}

/**
 * Test Connection submit .
 */
function testConnection_submit($form, &$form_state) {
  $db_key = get_ex_db_connection();
  if ($db_key === 'external_db_login_connection') {
    drupal_set_message(t('Connection created'));
  }
  else {
    drupal_set_message(t('Connection not created'), 'error');
  }
}

/**
 * Get Connection.
 */
function get_ex_db_connection() {
  try {
    createConnection();
    $connection = Database::getConnection();
  }
  catch (PDOException $e) {
    $connection = Database::getConnection('default', 'default');
  }
  return $connection->getKey();
}

/**
 * Create connection with new database information.
 */
function createConnection() {
  global $user;
  $variable = variable_get('external_db_login');
  // Set data in $info array.
  $info = array(
      'database' => $variable['ex_login_database'],
      'username' => $variable['ex_login_username'],
      'password' => $variable['ex_login_password'],
      'host' => $variable['ex_login_host'],
      'port' => $variable['ex_db_login_port'],
      'driver' => $variable['ex_login_driver'],
  );
   if(array_search('', $info)) {
     if ($user->uid >= 1) {
       drupal_set_message(t('External DB login module is not configure.'), 'warning');
     }
     return TRUE;
   }
  // Add connection with new database setting.
  Database::addConnectionInfo('external_db_login_connection', 'default', $info);
  try {
    // Active new connection.
    if(Database::getConnection('external_db_login_connection')) {
    db_set_active('external_db_login_connection');
  }
  }
  catch (PDOException $e) {
    // Active default connection if new connection is not stablished.
    db_set_active();
  }
}

/**
 * Check user exist in external database or not.
 *
 * @param mixed $email
 *   Pass email id.
 * @param mixed $password
 *   Pass Password.
 */
function checkUser($email, $password) {
  require './includes/password.inc';
  $variable = variable_get('external_db_login');
  $get_encrypt_type = $variable['ex_login_password_encypt'];
  $password_encrypt = encryptPassword($get_encrypt_type, $password, $email);
  if (!empty($password_encrypt)) {
    $auth_password = authUserAccount($email, $password_encrypt);
    $create_new_user = FALSE;
    if (!empty($auth_password)) {
      $check_user_exist = user_load_by_mail($email);
      if ($check_user_exist) {
        $uid = $check_user_exist->uid;
        $password = user_hash_password($password);
        $update = db_update('users')->fields(array('pass' => $password))->condition('uid', $uid)->execute();
        $create_new_user = $update;
        $username = $check_user_exist->name;
      }
      else {
        $username_array = explode('@', $email);
        $username = $username_array[0];
        $load_user = user_load_by_name($username);
        if ($load_user) {
          $username = $username . '_' . $load_user->value . mt_rand(0, 10000);
        }
        $new_user = array(
            'name' => $username,
            'mail' => $email,
            'pass' => $password,
            'signature_format' => 'full_html',
            'status' => 1,
            'language' => 'en',
            'access' => REQUEST_TIME,
            'roles' => array(),
        );
        $create_new_user = user_save(NULL, $new_user);
      }
    }
    if (!empty($create_new_user) && !empty($username)) {
      return $username;
    }
    else {
      return FALSE;
    }
  }
  else {
    $load_user_by_name = user_load_by_name($email);
    $load_user_by_email = user_load_by_mail($email);
    if ($load_user_by_name) {
      return $email;
    }
    elseif ($load_user_by_email) {
      $username = $load_user_by_email->name;

      return $username;
    }
    return FALSE;
  }
}

/**
 * Encrypt password.
 *
 * @param mixed $encypt_value
 *   Selected encrypt value.
 * @param mixed $password
 *   Pass password.
 * @param mixed $email
 *   Pass email id.
 */
function encryptPassword($encypt_value, $password, $email) {
  // Get user hash value fron service.
  $userhash = getUserPasswordHash($email);
  if (empty($userhash)) {
    return FALSE;
  }
  return $userhash;
}

/**
 * Check Password.
 *
 * @param mixed $password
 *   Pass password.
 * @param mixed $hash
 *   Pass user's hash value.
 * @param mixed $user_id
 *   Pass user id.
 */
function externalCheckPassword($password, $hash, $user_id = '') {
  require './includes/password.inc';
  // If the hash is still md5.
  if (strlen($hash) <= 32) {
    $hashpassword = user_hash_password($password);
    if ($hashpassword && $user_id) {
      $hash = $hashpassword;
    }
    return $hash;
  }

  // If the stored hash is longer than an MD5, presume the
  // new style phpass portable hash.
  $hash = user_hash_password($password);

  return $hash;
}

/**
 * Get user has value from external database.
 *
 * @param mixed $email
 *   Pass email id.
 */
function getUserPasswordHash($email) {
  // Create connection and active external database.
  $variable = variable_get('external_db_login');
  createConnection();
  $connection = Database::getConnection();
  try {
    // Get set information of user table.
    $user_table = $variable['ex_login_user_table'];
    $email_field = $variable['ex_login_field_email'];
    $password_field = $variable['ex_login_field_pass'];
    // Get password has value if user exist in database.
    $user_data = db_select($user_table, 'u');
    $user_data->fields('u', array($password_field));
    $user_data->condition($email_field, $email);
    $user_result = $user_data->execute()->fetchObject();
    // Set dafault database.
    db_set_active();
    if (!empty($user_result) && count($user_result) > 0) {
      // Return password has value.
      return $user_result->$password_field;
    }
    else {
      // Return false if not exist.
      return FALSE;
    }
  }
  catch (PDOException $e) {
    // Handel database exception.
    drupal_set_message($e->getMessage(), 'error');
    watchdog_exception('external_db_login', $e);
    return FALSE;
  }
}

/**
 * Authenticate new user.
 *
 * @param mixed $email
 *   Pass new user's email-id.
 * @param mixed $password
 *   Pass new user's password.
 */
function authUserAccount($email, $password) {
  $variable = variable_get('external_db_login');
  createConnection();
  $connection = Database::getConnection();
  try {
    // Create connection and active external database.
    // Get set information of user table.
    $user_table = $variable['ex_login_user_table'];
    $email_field = $variable['ex_login_field_email'];
    $password_field = $variable['ex_login_field_pass'];
    // Check if user is exist in external database.
    $user_data = db_select($user_table, 'u');
    $user_data->fields('u', array($email_field));
    $user_data->condition($email_field, $email);
    $user_data->condition($password_field, $password);
    $user_result = $user_data->execute()->fetchObject();
    // Active default database.
    db_set_active();
    // If user found return email id of that user.
    if (!empty($user_result) && count($user_result) > 0) {
      return $user_result->$email_field;
    }
    else {
      // If user not found return false.
      return FALSE;
    }
  }
  catch (PDOException $e) {
    // Handle exception found.
    drupal_set_message($e->getMessage(), 'error');
    watchdog_exception('external_db_login', $e);
    return FALSE;
  }
}
