(function (Drupal, once) {
  Drupal.behaviors.xnttSortableSelect = {
    attach: function (context, settings) {
      once('xntt-sortable-select', '.xntt-sortable-select', context).forEach(
        function (select) {
          const moveUpBtn = document.createElement('button');
          moveUpBtn.type = 'button';
          moveUpBtn.textContent = '↑';
          moveUpBtn.addEventListener('click', function() {
            for (let i = 0; i < select.options.length; ++i) {
              if (select.options[i].selected && i > 0) {
                const prev_option = select.options[i - 1];
                if (prev_option.selected) {
                  continue;
                }
                const option = select.options[i];
                select.insertBefore(
                  option,
                  prev_option
                );
                i--;
              }
            }
          }
        );

        const moveDownBtn = document.createElement('button');
        moveDownBtn.type = 'button';
        moveDownBtn.textContent = '↓';
        moveDownBtn.addEventListener('click', function() {
          for (let i = select.options.length - 1; i >= 0; --i) {
            if (select.options[i].selected
                && i < select.options.length - 1
            ) {
              const next_option = select.options[i + 1];
              if (next_option.selected) {
                continue;
              }
              const option = select.options[i];
              select.insertBefore(option, next_option.nextSibling);
            }
          }
        });

        const wrapper = document.createElement('div');
        wrapper.className = 'xntt-sortable-select-wrapper';
        select.parentNode.insertBefore(wrapper, select);
        wrapper.appendChild(select);
        wrapper.appendChild(moveUpBtn);
        wrapper.appendChild(moveDownBtn);
      });
    }
  };
})(Drupal, once);
