# Extra CSS UI

Provides a secure, admin-friendly interface to add site-wide CSS additions and
overrides directly through the Drupal UI.

This module allows site administrators to add/override CSS rules without
touching code or theme files.  
The CSS is stored in configuration, sanitised for safety, and served as a proper
`.css` file that loads after all theme CSS, ensuring your overrides take effect
reliably.

---

## Features

- Add and override site-wide CSS directly in the Drupal admin interface.
- Clean UI with syntax highlighting (CodeMirror-based).
- Safe sanitisation that strips harmful protocols and, optionally,  `@import`
  statements.
- Output served as a proper `.css` file (cached, aggregated, CDN-safe).
- Configurable theme, library, and filename integration; works with any theme.
- Loads after the theme’s main stylesheet, preserving CSS cascade order.
- No database hacks, no extra custom fields/logic, no inline styles.

---

## Requirements

- Drupal 10 or 11
- PHP 8.1 or higher

No external libraries are required, though the CodeMirror library is included
for enhanced editing.

---

## Installation

1. Install and enable the module as usual:

   ```bash
   composer require drupal/extra_css_ui
   drush en extra_css_ui
   drush cr
   ```

2. Visit the module's admin page at `/admin/config/development/extra-css-ui` (
   Configuration > Development > Extra CSS UI), open the 'Configuration'
   fieldset and configure the following settings:
   a. Frontend theme: Select the theme you want to apply this CSS too.
   b. Theme library name: Select the name of the library in the theme's
   *.libraries.yml* file that includes your final CSS. (Typically this is
   global-styling but can eb different in some cases)
   c. Filename: Enter the filename you want to use for your CSS. (This just
   changes the filename output in the source code)
   d. Sanitise `@import` statements: Check this box to strip `@import`
   statements from your CSS.
   e. Maximum size (KB): Set the maximum filesize allowed for the CSS file.
   Additional CSS will be truncated if the file size exceeds this limit.  
   f. Save settings via the 'Save configuration' button.

3. Add your CSS rules and save.

4. Visit your site to see the changes. (Clear caches if needed)

---

## Roadmap

Possible future features for this module (not yet in place) include:

- Domains module compatibility to allow per-domain CSS overrides.
- CSS minification.
- Improved validation/auto-complete tools in the editor.
- Integration with CSS aggregation tools.
- Allow for SCSS/LESS/etc. syntax.
- Additional sanitisation.
- More robust error handling.
