<?php

namespace Drupal\extra_field\Drush\Generators;

use DrupalCodeGenerator\Asset\AssetCollection;
use DrupalCodeGenerator\Command\BaseGenerator;
use Psr\Container\ContainerInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Generator class for extra_field form plugin.
 */
class ExtraFieldForm extends BaseGenerator {
  use StringTranslationTrait;

  /**
   * The module handler.
   *
   * @var \Drupal\Core\Extension\ModuleHandlerInterface
   */
  protected $moduleHandler;

  /**
   * Constructs a new ExtraFieldForm object.
   *
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler.
   */
  public function __construct(ModuleHandlerInterface $module_handler) {
    parent::__construct();
    $this->moduleHandler = $module_handler;
  }

  /**
   * Factory method to create a new instance of this class.
   *
   * @param \Psr\Container\ContainerInterface $container
   *   The container.
   *
   * @return static
   *   A new instance of this class.
   */
  public static function create(ContainerInterface $container): self {
    return new static(
      $container->get('module_handler')
    );
  }

  /**
   * The command name.
   *
   * @var string
   */
  protected $name = 'plugin:extra-field-form';

  /**
   * The command description.
   *
   * @var string
   */
  protected $description = 'Generates an extra field form plugin.';

  /**
   * The command alias.
   *
   * @var string
   */
  protected $alias = 'extra-field-form';

  /**
   * A path where templates are stored.
   *
   * @var string
   */
  protected $templatePath = __DIR__;

  /**
   * {@inheritdoc}
   */
  protected function generate(array &$vars, AssetCollection $assets): void {
    $assets->addFile('src/Plugin/ExtraField/Form/{class}.php')
      ->template('extra-field-form.twig');
  }

}
