# Extra Hero

Adds the Extra Hero block type plus sample content for Drupal recipes.

## Requirements

- Drupal core >= 10.4
- For best UX, use the Basecore theme, which provides the intended styling for this block: https://www.drupal.org/project/basecore

## Installation

Apply this recipe through the Recipes UI or with Drush. If you use the UI, you can also enable it via the Extra Project Browser, which groups the `extra_*` recipes: https://www.drupal.org/project/extra_project_browser

## What this recipe provides

- Block type: Extra Hero
- Fields and form/display configuration for the block type
- Sample content in `content/`

## Extra Hero block

Extra Hero is a flexible landing-page hero block that pairs bold headline text with a supporting image and a call-to-action area. It is designed for marketing-style pages where you want a strong first impression with a primary message, supporting copy, and one or more links.

Key parts of the block:
- Title: multiple title lines for a rotating headline effect.
- Description: rich text summary beneath the title.
- Note: short supporting text (for example, pricing or a brief disclaimer).
- Media: a single image with alt and title text.
- Alignment: horizontal (left/right) and vertical (top/center/bottom) alignment controls.
- Layout: column width options to control text vs. image emphasis.
- Actions: one or more links (URL + link text) for calls to action.

The sample content in `content/` includes a hero image and a demo Extra Hero block to help you preview and test the layout quickly.

## Configuration

All configuration is included in the recipe under `config/` and is installed when the recipe is applied.

## Maintainers

- TODO: Add maintainers and contact information.

## License

GPL-2.0-or-later. See `LICENSE.txt`.
