/**
 * @file
 * Support for facets_form event dispatching for facets_form_fulltext plugin.
 */

(function (Drupal) {

  'use strict';

  /**
   * @type {Drupal.facetsForm.pluginClass}
   */
  Drupal.facetsFormFulltext = {

    getEventName(widget) {
      return 'change';
    },

    setFilters(widget, dispatchEvent) {
      const facet = widget.dataset.drupalFacetsFormFacet;
      let filters = Array();
      let search = widget.querySelector('input[type="text"][name="' + facet + '"]').value;

      filters.push(search);
      widget.form.filters.setFilters(facet, filters, widget, dispatchEvent);
    }
  }

})(Drupal);
