<?php

declare(strict_types=1);

namespace Drupal\Tests\facets_form_fulltext\Functional;

use Drupal\facets\Entity\Facet;
use Drupal\Tests\BrowserTestBase;
use Drupal\Tests\facets\Functional\BlockTestTrait;
use Drupal\Tests\facets\Functional\ExampleContentTrait;
use Drupal\Tests\facets_form\Traits\FacetUrlTestTrait;

/**
 * Test the facets form fulltext.
 *
 * @group facets_form
 */
class IntegrationTest extends BrowserTestBase {

  use ExampleContentTrait;
  use BlockTestTrait;
  use FacetUrlTestTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'block',
    'facets_form_fulltext',
    'facets_search_api_dependency',
    'node',
    'search_api',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();

    $this->setUpExampleStructure();
    $this->insertExampleContent();
    $this->assertSame(5, $this->indexItems('database_search_index'));
  }

  /**
   * Test the full text with the "Equals" operator.
   */
  public function testEqualsOperator(): void {
    $assert = $this->assertSession();

    $this->createFacet('Llama', 'llama', 'name');
    $facet = Facet::load('llama');
    $facet->setWidget('facets_form_fulltext');
    $facet->save();

    $this->drupalPlaceBlock('facets_form:search_api:views_page__search_api_test_view__page_1');
    $this->drupalGet('search-api-test-fulltext');

    $assert->elementsCount('css', '.views-row', 5);
    $form = $assert->elementExists('css', 'form#facets-form');

    $form->fillField('Search', 'foo');
    $assert->buttonExists('Search', $form)->press();
    $assert->elementsCount('css', '.views-row', 3);

    $form->fillField('Search', 'foo baz');
    $assert->buttonExists('Search', $form)->press();
    $assert->elementsCount('css', '.views-row', 1);
  }

  /**
   * Test the full text with the "AND" operator.
   */
  public function testAndOperator(): void {
    $assert = $this->assertSession();

    $this->createFacet('Llama', 'llama', 'name');
    $facet = Facet::load('llama');
    $facet->setWidget('facets_form_fulltext', [
      'operator' => 'AND',
    ]);
    $facet->save();

    $this->drupalPlaceBlock('facets_form:search_api:views_page__search_api_test_view__page_1');
    $this->drupalGet('search-api-test-fulltext');

    $assert->elementsCount('css', '.views-row', 5);
    $form = $assert->elementExists('css', 'form#facets-form');

    $form->fillField('Search', 'foo baz');
    $assert->buttonExists('Search', $form)->press();
    $assert->elementsCount('css', '.views-row', 2);

    $form->fillField('Search', 'baz foo');
    $assert->buttonExists('Search', $form)->press();
    $assert->elementsCount('css', '.views-row', 2);
  }

}
