<?php

namespace Drupal\facets_max_facets\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Settings form for Facets Max Facets.
 */
final class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['facets_max_facets.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'facets_max_facets_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('facets_max_facets.settings');

    $form['max_active_facets'] = [
      '#type' => 'number',
      '#title' => $this->t('Maximum active facets'),
      '#default_value' => $config->get('max_active_facets'),
      '#min' => 0,
      '#description' => $this->t('The maximum amount of facets to display on a page. NOTE: 0 disables the limit entirely.'),
      '#required' => TRUE,
    ];

    $form['limit_message'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Facet limit message'),
      '#default_value' => $config->get('limit_message') ?: 'Facet searching is limited to :max-count facets. To further refine your search you will need to remove some facets and then try other facets instead.',
      '#description' => $this->t('Message shown when the maximum number of facets is reached. Use :max-count as a placeholder for the configured maximum.'),
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->configFactory()
      ->getEditable('facets_max_facets.settings')
      ->set('max_active_facets', (int) $form_state->getValue('max_active_facets'))
      ->set('limit_message', $form_state->getValue('limit_message'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
