<?php

namespace Drupal\fakelogin\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure settings for fake login.
 *
 * @internal
 */
class FakeLoginConfigForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'fakelogin_config_form';
  }
  
  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['fakelogin.settings'];
  }  

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {

    $form = parent::buildForm($form, $form_state);

    $config = $this->config('fakelogin.settings');

    $form['login_path'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Set real login Path'),
      '#default_value' => $config->get('login_path') ?? "/real-login-path",
      '#required' => TRUE,
      '#description' => $this->t('Please provide a valid path start with "/".'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {

    $config = $this->config('fakelogin.settings');
    $config->set('login_path', $form_state->getValue('login_path'));
    $config->save();
    // rebuild the router.
    \Drupal::service('router.builder')->rebuild();

    return parent::submitForm($form, $form_state);
  }
}
