<?php

namespace Drupal\fakelogin\Routing;

use Symfony\Component\Routing\Route;
use Symfony\Component\Routing\RouteCollection;

/**
 * Defines dynamic routes.
 */
class FakeLoginRoutes {

  /**
   * {@inheritdoc}
   */
  public function routes() {
    $route_collection = new RouteCollection();
    $config = \Drupal::config('fakelogin.settings');

	$real_login_path = $config->get('login_path') ??"/real-login-path";
    // Add real login route.
    $real_login_route = new Route(
      $real_login_path,
      // Route defaults:
      [
        '_form' => '\Drupal\user\Form\UserLoginForm',
        '_title' => 'Log in',
      ],
      // Route requirements:
      [
        '_user_is_logged_in' => 'FALSE',
      ],
	  //Route options
      [
        '_maintenance_access' => TRUE,
      ]	  
    );
    // Add the route.
    $route_collection->add('fakelogin.reallogin', $real_login_route);

    return $route_collection;
  }
}
