// JavaScript Document

var fancyLogin = {};
var ctrlPressed = false;
var loginVisible = false;

fancyLogin.showLogin = function()
{
	if(!$("#fancy_login_dim_screen").length)
	{
		$("body").append("<div id=\"fancy_login_dim_screen\"></div>");
		$("#fancy_login_dim_screen").css({"position" : "fixed", "top" : "0", "left" : "0", "height" : "100%", "width" : "100%", "background-color" : Drupal.settings.fancyLogin.screenFadeColor, "z-index" : "10", "opacity" : "0"});
	}
	else
	{
		$("#fancy_login_dim_screen").css({"opacity" : "0", "display" : "block"});
	}
	$("#fancy_login_dim_screen").fadeTo(500, 0.8, function()
	{
		$("#fancy_login_login_box").fadeIn(1000);
		$("#fancy_login_login_box #edit-name").focus();
		fancyLogin.setClose($(this));
	});
	if(!$("#fancy_login_login_box").length)
	{
		$("body").append("<div id=\"fancy_login_login_box\"></div>");
		$("#fancy_login_login_box").css({"position" : "fixed", "width" : Drupal.settings.fancyLogin.loginBoxWidth, "height" : Drupal.settings.fancyLogin.loginBoxHeight});
		$("#fancy_login_login_box").load(Drupal.settings.fancyLogin.callbackURL, function()
		{
			$("#fancy_login_login_box #edit-name").focus();
			var wHeight = $(window).height();
			var wWidth = $(window).width();
			var eHeight = $("#fancy_login_login_box").height();
			var eWidth = $("#fancy_login_login_box").width();
			var eTop = (wHeight - eHeight) / 2;
			var eLeft = (wWidth - eWidth) / 2;
			$("#fancy_login_login_box").css({"top" : eTop, "left" : eLeft, "background-color" : Drupal.settings.fancyLogin.loginBoxBackgroundColor, "border-style" : Drupal.settings.fancyLogin.loginBoxBorderStyle, "border-color" : Drupal.settings.fancyLogin.loginBoxBorderColor, "border-width" : Drupal.settings.fancyLogin.loginBoxBorderWidth, "z-index" : "11", "display" : "none", "padding-left" : "15px", "padding-right" : "15px"})
			.fadeIn(1000);
			fancyLogin.setSubmit();
			$("#fancy_login_close_button").click(function()
			{
				fancyLogin.hideLogin();
				return false;
			});
		});
	}
}

fancyLogin.hideLogin = function()
{
	$("#fancy_login_login_box").fadeOut(800, function()
	{
		$("#fancy_login_dim_screen").fadeOut(800);
		$(window).focus();
	});
}

fancyLogin.setSubmit = function()
{
	$("#fancy_login_login_box form").submit(function()
	{
		fancyLogin.hideLogin
	});
	$("#fancy_login_login_box a").click(function()
	{
		fancyLogin.hideLogin
	});
}

fancyLogin.setClose = function(e)
{
	e.click(function()
	{
		fancyLogin.hideLogin();
	});
}

Drupal.behaviors.fancy_login = function()
{
	$("a[href='" + Drupal.settings.basePath + "user/login']").each(function()
	{
		$(this).click(function()
		{
			fancyLogin.showLogin();
			return false;
		});
	});
	$(document).keyup(function(event)
	{
		if(event.keyCode == 17)
		{
			ctrlPressed = false;
		}
	    if(event.keyCode == 27)
		{
	        fancyLogin.hideLogin();
	    }
	});
	$(document).keydown(function(event)
	{
		if(event.keyCode == 17)
		{
			ctrlPressed = true;
		}
		if(ctrlPressed == true && event.keyCode == 76)
		{
			ctrlPressed = false;
			if(loginVisible)
			{
				fancyLogin.hideLogin();
				loginVisible = false;
			}
			else
			{
				fancyLogin.showLogin();
				loginVisible = true;
			}
		}
	});
}