// $Id: fancy_login.js,v 1.15 2010/09/22 05:39:49 hakulicious Exp $

var fancyLogin = {};

fancyLogin.popupVisible = false;
fancyLogin.ctrlPressed = false;

fancyLogin.showLogin = function()
{
	var fl = fancyLogin;
	var settings = Drupal.settings.fancyLogin;
	var loginBox = $("#fancy_login_login_box");
	if(!fl.popupVisible)
	{
		fl.popupVisible = true;
		if(settings.hideObjects)
		{
			$("object, embed").css("visibility", "hidden");
		}
		$("#fancy_login_dim_screen").css({"position" : "fixed", "top" : "0", "left" : "0", "height" : "100%", "width" : "100%", "display" : "block", "background-color" : settings.screenFadeColor, "z-index" : settings.screenFadeZIndex, "opacity" : "0"}).fadeTo(settings.dimFadeSpeed, 0.8, function()
		{
			loginBox.css({"position" : "fixed", "width" : settings.loginBoxWidth, "height" : settings.loginBoxHeight});
			var wHeight = window.innerHeight ? window.innerHeight : $(window).height();
			var wWidth = $(window).width();
			var eHeight = loginBox.height();
			var eWidth = loginBox.width();
			var eTop = (wHeight - eHeight) / 2;
			var eLeft = (wWidth - eWidth) / 2;
			if($("#fancy_login_close_button").css("display") == "none")
			{
				$("#fancy_login_close_button").css("display", "inline");
			}
			loginBox.css({"top" : eTop, "left" : eLeft, "color" : settings.loginBoxTextColor, "background-color" : settings.loginBoxBackgroundColor, "border-style" : settings.loginBoxBorderStyle, "border-color" : settings.loginBoxBorderColor, "border-width" : settings.loginBoxBorderWidth, "z-index" : (settings.screenFadeZIndex + 1), "display" : "none", "padding-left" : "15px", "padding-right" : "15px"})
			.fadeIn(settings.boxFadeSpeed);
			loginBox.find(".form-text:first").focus().select();
			fl.setCloseListener();
		});
	}
};

fancyLogin.setCloseListener = function()
{
	var fl = fancyLogin;
	$("#fancy_login_dim_screen, #fancy_login_close_button").click(function()
	{
		fl.hideLogin();
		return false;
	});
	$("#fancy_login_login_box form").submit(function()
	{
		fl.submitted();
	});
	$("#fancy_login_login_box a:not('#fancy_login_close_button')").click(function()
	{
		fl.submitted();
	});
	$(document).keyup(function(event)
	{
	    if(event.keyCode == 27)
		{
	        fl.hideLogin();
	    }
	});
};

fancyLogin.hideLogin = function()
{
	var settings = Drupal.settings.fancyLogin;
	var fl = fancyLogin;
	if(fl.popupVisible)
	{
		fl.popupVisible = false;
		$("#fancy_login_login_box").fadeOut(settings.boxFadeSpeed, function()
		{
			$(this).css({"position" : "static", "height" : "auto", "width" : "auto",  "background-color" : "transparent", "border" : "none" });
			$("#fancy_login_dim_screen").fadeOut(settings.dimFadeSpeed, function()
			{
				if(settings.hideObjects)
				{
					$("object, embed").css("visibility", "visible");
				}
			});
			$(window).focus();
		});
	}
};

fancyLogin.submitted = function()
{
	var formContents = $("#fancy_login_form_contents");
	var ajaxLoader = $("#fancy_login_ajax_loader");
	var wHeight = formContents.height();
	var wWidth = formContents.width();
	ajaxLoader.css({"height" : wHeight, "width" : wWidth});
	formContents.fadeOut(300, function()
	{
		ajaxLoader.fadeIn(300);
		var img = ajaxLoader.children("img:first");
		var imgHeight = img.height();
		var imgWidth = img.width();
		var eMarginTop = (wHeight - imgHeight) / 2;
		var eMarginLeft = (wWidth - imgWidth) / 2;
		img.css({"margin-left" : eMarginLeft, "margin-top" : eMarginTop});
	});
};

Drupal.behaviors.fancyLogin = function()
{
	var settings = Drupal.settings.fancyLogin;
	var fl = fancyLogin;
	if(!$.browser.msie || $.browser.version > 6 || window.XMLHttpRequest)
	{
		$("a[href*='" + settings.loginPath + "']").each(function()
		{
			if(settings.destination)
			{
				var targetHREF = $(this).attr("href");
				if(targetHREF.search(/destination=/i) == -1)
				{
					targetHREF += Drupal.settings.fancyLogin.destination;
					$(this).attr("href", targetHREF);
				}
			}
			$(this).click(function()
			{
				var action = $(this).attr("href");
				if(settings.httpsRoot)
				{
					action = settings.httpsRoot + action;
				}
				$("#fancy_login_login_box form").attr("action", action);
				fl.showLogin();
				return false;
			});
		});
		$(document).keyup(function(e)
		{
			if(e.keyCode == 17)
			{
				fl.ctrlPressed = false;
			}
		});
		$(document).keydown(function(e)
		{
			if(e.keyCode == 17)
			{
				fl.ctrlPressed = true;
			}
			if(fl.ctrlPressed === true && e.keyCode == 190)
			{
				fl.ctrlPressed = false;
				if(fl.popupVisible)
				{
					fl.hideLogin();
				}
				else
				{
					fl.showLogin();
				}
			}
		});
	}
};