// $Id: fancy_login.js,v 1.18 2011/01/25 08:41:24 hakulicious Exp $
(function($)
{
	var popupVisible = false;
	var ctrlPressed = false;

	function showLogin()
	{
		var settings = Drupal.settings.fancyLogin;
		var loginBox = $("#fancy_login_login_box");
		if(!popupVisible) {
			popupVisible = true;
			if(settings.hideObjects) {
				$("object, embed").css("visibility", "hidden");
			}
			$("#fancy_login_dim_screen").css({"position" : "fixed", "top" : "0", "left" : "0", "height" : "100%", "width" : "100%", "display" : "block", "background-color" : settings.screenFadeColor, "z-index" : settings.screenFadeZIndex, "opacity" : "0"}).fadeTo(settings.dimFadeSpeed, 0.8, function()
			{
				loginBox.css({"position" : "fixed", "width" : settings.loginBoxWidth, "height" : settings.loginBoxHeight});
				var wHeight = window.innerHeight ? window.innerHeight : $(window).height();
				var wWidth = $(window).width();
				var eHeight = loginBox.height();
				var eWidth = loginBox.width();
				var eTop = (wHeight - eHeight) / 2;
				var eLeft = (wWidth - eWidth) / 2;
				if($("#fancy_login_close_button").css("display") === "none") {
					$("#fancy_login_close_button").css("display", "inline");
				}
				loginBox.css({"top" : eTop, "left" : eLeft, "color" : settings.loginBoxTextColor, "background-color" : settings.loginBoxBackgroundColor, "border-style" : settings.loginBoxBorderStyle, "border-color" : settings.loginBoxBorderColor, "border-width" : settings.loginBoxBorderWidth, "z-index" : (settings.screenFadeZIndex + 1), "display" : "none", "padding-left" : "15px", "padding-right" : "15px"})
				.fadeIn(settings.boxFadeSpeed);
				loginBox.find(".form-text:first").focus().select();
				setCloseListener();
			});
		}
	}

	function setCloseListener()
	{
		$("#fancy_login_dim_screen, #fancy_login_close_button").click(function()
		{
			hideLogin();
			return false;
		});
		$("#fancy_login_login_box form").submit(function()
		{
			submitted();
		});
		$("#fancy_login_login_box a:not('#fancy_login_close_button')").click(function()
		{
			submitted();
		});
		$(document).keyup(function(event)
		{
		    if(event.keyCode === 27) {
		        hideLogin();
		    }
		});
	}

	function hideLogin()
	{
		var settings = Drupal.settings.fancyLogin;
		if(popupVisible) {
			popupVisible = false;
			$("#fancy_login_login_box").fadeOut(settings.boxFadeSpeed, function()
			{
				$(this).css({"position" : "static", "height" : "auto", "width" : "auto",  "background-color" : "transparent", "border" : "none" });
				$("#fancy_login_dim_screen").fadeOut(settings.dimFadeSpeed, function()
				{
					if(settings.hideObjects) {
						$("object, embed").css("visibility", "visible");
					}
				});
				$(window).focus();
			});
		}
	}

	function submitted(requestPassword)
	{
		var formContents = $("#fancy_login_form_contents");
		var ajaxLoader = $("#fancy_login_ajax_loader");
		var wHeight = formContents.height();
		var wWidth = formContents.width();
		ajaxLoader.css({"height" : wHeight, "width" : wWidth});
		formContents.fadeOut(300, function()
		{
			ajaxLoader.fadeIn(300);
			var img = ajaxLoader.children("img:first");
			var imgHeight = img.height();
			var imgWidth = img.width();
			var eMarginTop = (wHeight - imgHeight) / 2;
			var eMarginLeft = (wWidth - imgWidth) / 2;
			img.css({"margin-left" : eMarginLeft, "margin-top" : eMarginTop});
			if(requestPassword) {
				getRequestPassword();
			}
		});
	}

	function getRequestPassword()
	{
		var settings = Drupal.settings;
		var passwordPath = settings.fancyLogin.loginPath.replace(/login/, "password");
		$.ajax(
		{
			url:settings.basePath + passwordPath,
			dataFilter:function(data)
			{
				return $(data).find("#user-pass");
			},
			success:function(data)
			{
				var formContents = $("#fancy_login_form_contents");
				formContents.children("form").css("display", "none");
				var itemList = formContents.find(".item-list");
				itemList.before(data);
				$("#fancy_login_ajax_loader").fadeOut(300, function()
				{
					toggle = $("<li><a id=\"toggle_link\" href=\"#\">" + Drupal.t("Login") + "</a></li>");
					toggle.click(function()
					{
						toggleForm();
					});
					itemList.children("ul").append(toggle);
					$("#user-pass").attr("action", $("#user-pass").attr("action") + settings.fancyLogin.requestDestination);
					formContents.fadeIn(300);
				});
			}
		});
	}

	function toggleForm()
	{
		currentForm = ($("#fancy_login_form_contents #user-login").css("display") === "none") ? "#user-pass" : "#user-login";
		targetForm = (currentForm === "#user-login") ? "#user-pass" : "#user-login";
		linkText = (currentForm === "#user-login") ? Drupal.t("Login") : Drupal.t("Request new password");
		$(currentForm).fadeOut(300, function()
		{
			$(targetForm).fadeIn(300);
		});
		$("#fancy_login_form_contents .item-list").fadeOut(300, function()
		{
			$("#toggle_link").text(linkText);
			$("#fancy_login_form_contents .item-list").fadeIn(300);
		});
	}

	Drupal.behaviors.fancyLogin = 
	{
		attach:function()
		{
			var settings = Drupal.settings.fancyLogin;
			if(!$.browser.msie || $.browser.version > 6 || window.XMLHttpRequest) {
				$("a[href*='" + settings.loginPath + "']").each(function()
				{
					if(settings.destination) {
						var targetHREF = $(this).attr("href");
						if(targetHREF.search(/destination=/i) === -1) {
							targetHREF += settings.destination;
							$(this).attr("href", targetHREF);
						}
					}
					$(this).click(function()
					{
						var action = $(this).attr("href");
						if(settings.httpsRoot) {
							action = settings.httpsRoot + action;
						}
						$("#fancy_login_login_box form").attr("action", action);
						showLogin();
						return false;
					});
				});
				$(document).keyup(function(e)
				{
					if(e.keyCode === 17) {
						ctrlPressed = false;
					}
				});
				$(document).keydown(function(e)
				{
					if(e.keyCode === 17) {
						ctrlPressed = true;
					}
					if(ctrlPressed === true && e.keyCode === 190) {
						ctrlPressed = false;
						if(popupVisible) {
							hideLogin();
						} else {
							showLogin();
						}
					}
				});
				$("#fancy_login_login_box a[href*='" + settings.loginPath.replace(/login/, "password") + "']").click(function()
				{
					$(this).fadeOut(200);
					submitted(true);
					return false;
				});
			}
		}
	};
}(jQuery));