<?php
/**
 * @file
 * Contains \Drupal\fancy_login\Controller\FancyLoginController.
 */
 
namespace Drupal\fancy_login\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\Component\Serialization\Json;

class FancyLoginController extends ControllerBase {

  /**
   * {@inheritdoc}
   */
  public function ajax_callback($type) {
    switch($type) {
      case "password":
        $form = \Drupal::formBuilder()->getForm('Drupal\fancy_login\Form\FancyLogin_passForm');
      break;
      case "login":
        $form = \Drupal::formBuilder()->getForm('Drupal\fancy_login\Form\FancyLogin_loginForm');
        unset($form['#prefix'], $form['#suffix']);
      break;
    }

	$rendered_form = render($form);

    $scripts = drupal_js_defaults();
    if (!empty($scripts['drupalSettings'])) {
      //unset($scripts['drupalSettings']['data']['path']);
      $settings = '<script type="text/javascript">jQuery.extend(drupalSettings, ';
      $settings .= Json::encode($scripts['drupalSettings']['data']);
      $settings .= ');</script>';
    }
    $return = array('content' => $rendered_form . $settings, 'status' => TRUE, 'type' => $type);

    return new JsonResponse($return);
  }

}
