<?php

/**
 * @file
 * Contains \Drupal\fancy_login\Plugin\Block\FancyLoginBlock.
 */

namespace Drupal\fancy_login\Plugin\Block;

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Url;

/**
 * Provides a 'Fancy Login' block.
 *
 * @Block(
 *   id = "fancy_login_login_block",
 *   admin_label = @Translation("Login"),
 *   category = @Translation("Fancy Login Link")
 * )
 */

class FancyLoginBlock extends BlockBase {

  /**
   * {@inheritdoc}
   */
  public function build() {
    if(\Drupal::currentUser()->isAnonymous() || !empty($GLOBALS['menu_admin'])) {
      $url = Url::fromRoute('user.login');
      return array(
        'link' => array(
          '#markup' => \Drupal::l(t('Login'), $url),
          '#prefix' => '<div id="fancy_login_login_link_wrapper">',
          '#suffix' => '</div>',
        ),
      );
    }
  }

}