<?php
 
namespace Drupal\fancy_login\Controller;

use Drupal\Component\Serialization\Json;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Form\FormBuilder;
use Drupal\Core\Render\BubbleableMetadata;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;

class FancyLoginController extends ControllerBase implements FancyLoginControllerInterface
{
	/**
	 * The form buidler service
	 *
	 * @var \Drupal\Core\Form\FormBuilder
	 */
	protected $formBuilder;

	/**
	 * {@inheritdoc}
	 */
	public static function create(ContainerInterface $container)
	{
		return new static
		(
			$container->get('form_builder')
		);
	}

	/**
	 * Constructs the FancyLoginController object
	 *
	 * @param \Drupal\Core\Form\FormBuilder $formBuilder
	 *   The form builder service
	 */
	public function __construct(FormBuilder $formBuilder)
	{
		$this->formBuilder = $formBuilder;
	}

	/**
	 * {@inheritdoc}
	 */
	 public function ajax_callback($type)
	 {
		switch($type)
		{
			case "password":
				$form = $this->formBuilder->getForm('Drupal\fancy_login\Form\FancyLoginPasswordForm');

				break;

			case "login":
				$form = $this->formBuilder->getForm('Drupal\fancy_login\Form\FancyLoginLoginForm');
				unset($form['#prefix'], $form['#suffix']);

				break;
		}

		$rendered_form = render($form);

		$data = BubbleableMetadata::createFromRenderArray($form);
		$attachments = $data->getAttachments();

		if(!empty($attachments['drupalSettings']))
		{
			$settings .= '<script type="text/javascript">jQuery.extend(drupalSettings, ';
			$settings .= Json::encode($attachments['drupalSettings']);
			$settings .= ');</script>';
		}

		$response = [
			'content' => $rendered_form . $settings,
			'status' => TRUE,
			'type' => $type,
		];

		return new JsonResponse($response);
	}
}
