# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [3.4.6] 2025-11-17

### Changed

- [Pin Docker base image to Debian Bookworm #991](https://github.com/farmOS/farmOS/pull/991)

### Removed

- [Remove dependency on JSON:API Extras module #964](https://github.com/farmOS/farmOS/pull/964)
- [Remove dependency on Migrate Source UI module #994](https://github.com/farmOS/farmOS/pull/994)

### Fixed

- [Fix plan_record bundle field providers #969](https://github.com/farmOS/farmOS/pull/969)
- [Fix logic for forcing entity revision creation #988](https://github.com/farmOS/farmOS/pull/969)
- [Check that real path exists before loading exif data #1000](https://github.com/farmOS/farmOS/pull/1000)

### Security

- Updated Drupal core to 10.4.9 for
  [SA-CORE-2025-005](https://www.drupal.org/sa-core-2025-005),
  [SA-CORE-2025-006](https://www.drupal.org/sa-core-2025-006),
  [SA-CORE-2025-007](https://www.drupal.org/sa-core-2025-007), and
  [SA-CORE-2025-008](https://www.drupal.org/sa-core-2025-008).

## [3.4.5] 2025-04-28

### Fixed

- [Fix hidden entity fields #950](https://github.com/farmOS/farmOS/pull/950)
- [Fix missing Assets tab on locations #951](https://github.com/farmOS/farmOS/pull/951)
- [Validate entities generated by quick trait methods #953](https://github.com/farmOS/farmOS/pull/953)
- [Link to upcoming tasks with appropriate sort direction #954](https://github.com/farmOS/farmOS/pull/954)
- [Gracefully handle invalid entity IDs in Views access checks #952](https://github.com/farmOS/farmOS/pull/952)

## [3.4.4] 2025-04-03

### Changed

- [Automatically rotate derivative images based on EXIF Orientation #941](https://github.com/farmOS/farmOS/pull/941)
- [Allow WebP files in image fields #942](https://github.com/farmOS/farmOS/pull/942)

### Fixed

- [Fix Warning: Undefined array keys in hook_views_pre_render() #937](https://github.com/farmOS/farmOS/pull/937)
- [Fix TypeError: CircularAssetLocationConstraintValidator::getAssetsByLocationRecursively(): Argument #2 ($timestamp) must be of type int, string given #938](https://github.com/farmOS/farmOS/pull/938)
- [Fix CSV importer compatibility with migrate_source_ui v1.3+ #993](https://github.com/farmOS/farmOS/pull/993)

## [3.4.3] 2025-03-20

### Security

- Update Drupal core to 10.4.5 for [SA-CORE-2025-004](https://www.drupal.org/sa-core-2025-004)

## [3.4.2] 2025-03-18

### Fixed

- [Issue #3511488: Refreshed access_token is missing scope with league/oauth2-server ^9](https://www.drupal.org/project/simple_oauth_password_grant/issues/3511488)
- [Cast processed text exported to CSV as a string #931](https://github.com/farmOS/farmOS/pull/931)
- [Fix TypeError on invalid /asset/%asset_id/assets path #932](https://github.com/farmOS/farmOS/pull/932)
- [Restore missing transplant_days field on plant_type terms #935](https://github.com/farmOS/farmOS/pull/935)
- [Fix TypeError during installation of farmOS API module #936](https://github.com/farmOS/farmOS/pull/936)

## [3.4.1] 2025-02-19

### Security

- Update Drupal core to 10.4.3 for
  [SA-CORE-2025-001](https://www.drupal.org/sa-core-2025-001),
  [SA-CORE-2025-002](https://www.drupal.org/sa-core-2025-002), and
  [SA-CORE-2025-003](https://www.drupal.org/sa-core-2025-003)

## [3.4.0] 2025-02-19

### Added

- [Add Equipment type field to Equipment assets #894](https://github.com/farmOS/farmOS/pull/894)
- [Add support for geometry fields in CSV exports #884](https://github.com/farmOS/farmOS/pull/884)
- [Allow modules to add base fields to farmOS Views #915](https://github.com/farmOS/farmOS/pull/915)
- [Allow modules to add base fields to default CSV importers #916](https://github.com/farmOS/farmOS/pull/916)
- [Add support for boolean fields in CsvImportMigrationBase::addFieldMapping() #917](https://github.com/farmOS/farmOS/pull/917)
- [Add group and is_group_assignment base fields to log CSV importers #919](https://github.com/farmOS/farmOS/pull/919)
- [Document Plan Records in the data model #929](https://github.com/farmOS/farmOS/pull/929)

### Changed

- [Pin PHP version to 8.3 in Dockerfile #923](https://github.com/farmOS/farmOS/pull/923)
- [Update farmOS-map to 2.4.0 #926](https://github.com/farmOS/farmOS/pull/926)
- [Delete associated plan_record entities when a plan is deleted #928](https://github.com/farmOS/farmOS/pull/928)

### Deprecated

- [Issue #3498064: Deprecate d7_plan plugin](https://www.drupal.org/project/farm/issues/3498064)
- [Issue #3498067: Deprecate data stream migration plugins](https://www.drupal.org/project/farm/issues/3498067)

### Fixed

- [CSV import validation messages not showing #924](https://github.com/farmOS/farmOS/issues/924)

## [3.3.3] 2025-01-07

Note: The `farmos/farmos:3.x` and `farmos/farmos:3.3.3` Docker images include
PHP 8.3 (because it is based on the `drupal:10.4` Docker image). Please make
sure any custom code is compatible with PHP 8.3 before updating.

### Changed

- [Update Drupal core to 10.4 #900](https://github.com/farmOS/farmOS/pull/900)
- [Update to stable Gin 4.0.0 #903](https://github.com/farmOS/farmOS/pull/903)
- [Update simple_oauth to 6.0.0-beta7 #893](https://github.com/farmOS/farmOS/pull/893)
- [Update simple_oauth to 6.0.0-beta8 and unpin version constraint #905](https://github.com/farmOS/farmOS/pull/905)

### Fixed

- [Permissions page is blank #887](https://github.com/farmOS/farmOS/issues/887)

## [3.3.2] 2024-11-20

### Fixed

- [Fix config export via UI #883](https://github.com/farmOS/farmOS/pull/883)
- [Fix group location logic #888](https://github.com/farmOS/farmOS/pull/888)
- [Fix farm_log_quantity View alterations by farm_ui_views #891](https://github.com/farmOS/farmOS/pull/891)
- [Fix "explode: NULL is not a string" when multi-value CSV columns are omitted #895](https://github.com/farmOS/farmOS/pull/895)

### Security

- [Update Drupal core to 10.3.9 #892](https://github.com/farmOS/farmOS/pull/892)

## [3.3.1] 2024-09-26

This fixes a critical issue in the upgrade path from farmOS 3.2.x to 3.3.x. For
more information, see https://github.com/farmOS/farmOS/pull/881.

### Changed

- [Do not delete quantities when they are removed from a log #882](https://github.com/farmOS/farmOS/pull/882)

### Fixed

- [Remove dependency on admin_toolbar:admin_toolbar_links_access_filter #881](https://github.com/farmOS/farmOS/pull/881)
- [Fix warning message when loading values from empty form state #880](https://github.com/farmOS/farmOS/pull/880)

## [3.3.0] 2024-09-24

### Added

- [Add bulk delete action to farm_log_quantity View #860](https://github.com/farmOS/farmOS/pull/860)
- [Add an "Export Quantity CSV" bulk action to Log Views](https://github.com/farmOS/farmOS/pull/861)
- [Allow modules to alter dashboard panes #868](https://github.com/farmOS/farmOS/pull/868)
- [Add geometry/location fields to CSV importers #815](https://github.com/farmOS/farmOS/pull/815)
- [Add an asset.logs service for retrieving logs that reference an asset #850](https://github.com/farmOS/farmOS/pull/850)
- [Add farmOS-timeline library (experimental) #862](https://github.com/farmOS/farmOS/pull/862)
- [Build multi-platform Docker images/manifests #864](https://github.com/farmOS/farmOS/pull/864)
- [Add a Soil texture field to Lab test logs #873](https://github.com/farmOS/farmOS/pull/873)

### Changed

- [Update Drupal core to 10.3 #872](https://github.com/farmOS/farmOS/pull/872)
- [Move farm_quantity View to farm_log_quantities and require log relationship #858](https://github.com/farmOS/farmOS/pull/858)
- [Quantity CSV export improvements #861](https://github.com/farmOS/farmOS/pull/861)
- [Reorder and improve entity field rendering #847](https://github.com/farmOS/farmOS/pull/847)

### Security

- [Sanitize CSV exports against formula injection #871](https://github.com/farmOS/farmOS/pull/871)

## [3.2.4] 2024-09-18

### Changed

- [Single Dockerfile using multi-stages for production and dev image #855](https://github.com/farmOS/farmOS/pull/855)
- [Simplify recommendation for XDEBUG_CONFIG in local development environments #870](https://github.com/farmOS/farmOS/pull/870)

### Fixed

- [Update drupal/consumers to ^1.19 and fix kernel API tests](https://github.com/farmOS/farmOS/pull/857)
- [When a quantity is deleted, clean up log references to it #859](https://github.com/farmOS/farmOS/pull/859)

## [3.2.3] 2024-07-21

### Fixed

- [Issue #3454144: Fix untranslated plant_type descriptions in plant and seed asset types](https://www.drupal.org/project/farm/issues/3454144)
- [Set owner of cloned assets to current user #851](https://github.com/farmOS/farmOS/pull/851)
- [Issue #3314741: EntityFieldManager::getFieldMap() doesn't show farmOS bundle fields](https://www.drupal.org/project/farm/issues/3314741)

## [3.2.2] 2024-05-17

### Added

- [Allow columns to be selected for inclusion in CSV exports #842](https://github.com/farmOS/farmOS/pull/842)

### Changed

- [Allow multiple locations to be referenced in the planting quick form #839](https://github.com/farmOS/farmOS/pull/839)
- [Update farmOS-map to v2.3.0 #841](https://github.com/farmOS/farmOS/pull/841) to [add the ability to use custom stroke colors #201](https://github.com/farmOS/farmOS-map/issues/201) (in custom map layers)
- [Improve comment settings and edit sidebar #846](https://github.com/farmOS/farmOS/pull/846)

### Removed

- [Remove default country from farm settings form #840](https://github.com/farmOS/farmOS/pull/840)

### Fixed

- [Remove data_table from existing plan_record entity type definition #829](https://github.com/farmOS/farmOS/pull/829)
- [Use farm_people entity_reference View for exposed Owner filter in farm_asset View #835](https://github.com/farmOS/farmOS/pull/835)
- [Require asset name in bulk KML importer #836](https://github.com/farmOS/farmOS/pull/836)
- [Fix incorrect CSV headers when exporting multiple record types #842](https://github.com/farmOS/farmOS/pull/842)

## [3.2.1] 2024-04-12

### Fixed

- Patch JSON:API Schema to fix [Issue #3390505: Error: uri is not a valid type for a JSON document](https://www.drupal.org/project/jsonapi_schema/issues/3390505)
- [Fix FieldException: Attempted to create a configurable field of non-configurable field storage image during update.php #828](https://github.com/farmOS/farmOS/pull/828)

## [3.2.0] 2024-04-10

### Added

- [Issue #3352183: Comments on farmOS records](https://www.drupal.org/project/farm/issues/3352183)
- [Add a Notes filter to the logs views #825](https://github.com/farmOS/farmOS/pull/825)
- [Add file and image base fields to all taxonomy terms #807](https://github.com/farmOS/farmOS/pull/807)
- [Issue #3390486: Add an Ontology URI field to all taxonomy terms](https://www.drupal.org/project/farm/issues/3390486)
- [Add "Days of harvest" field to Plant type terms #794](https://github.com/farmOS/farmOS/pull/794)
- [Plan record views integration #818](https://github.com/farmOS/farmOS/pull/818)
- [Add min/max options to decimal fields in farm_field.factory #822](https://github.com/farmOS/farmOS/pull/822)

### Changed

- [Set plant_type fields form/view display settings via alter hook instead of config #806](https://github.com/farmOS/farmOS/pull/806)
- [Make "done" the default log status #782](https://github.com/farmOS/farmOS/pull/782)
- [Set the minimum value of maturity_days and transplant_days to 1 #794](https://github.com/farmOS/farmOS/pull/794)
- [Move transplant_days field to farm_transplant module #795](https://github.com/farmOS/farmOS/pull/795)
- [Use content form for taxonomy terms #810](https://github.com/farmOS/farmOS/pull/810)
- [Override the lab_test log timestamp label and description #774](https://github.com/farmOS/farmOS/pull/774)
- [Override the birth log asset label and description #824](https://github.com/farmOS/farmOS/pull/824)

### Fixed

- [Fix Client error when passing asset parameter to forms #814](https://github.com/farmOS/farmOS/pull/814)
- [Update patch for Issue #3397275 to fix boolean field JSON Schema #819](https://github.com/farmOS/farmOS/pull/819)
- [Do not trim whitespace from quantity field item content #820](https://github.com/farmOS/farmOS/pull/820)
- [Do not install base modules when --existing-config is used #821](https://github.com/farmOS/farmOS/pull/821)

### Removed

- [Remove CSV export display from farm_plan View #809](https://github.com/farmOS/farmOS/pull/809)

## [3.1.2] 2024-02-26

### Fixed

- [Check for correct update operation access in location hierarchy form #800](https://github.com/farmOS/farmOS/pull/800)
- [Update to itamair/geophp 1.6 #801](https://github.com/farmOS/farmOS/pull/801) to fix deprecated function warnings.
- [Fix saving inventory quick form configuration with existing units term #803](https://github.com/farmOS/farmOS/pull/803)

## [3.1.1] 2024-02-07

### Fixed

- [Grant config permissions create quick_form permission #791](https://github.com/farmOS/farmOS/pull/791)
- Patch Gin to fix [Issue #3419904: Help text is cutoff at xsmall breakpoint](https://www.drupal.org/node/3419904)

### Security

- Update Migrate Tools to 6.0.3 for [SA-CONTRIB-2024-008](https://www.drupal.org/sa-contrib-2024-008)

## [3.1.0] 2024-02-02

### Added

- [Announce new releases on farmOS.discourse.group #780](https://github.com/farmOS/farmOS/pull/780)
- [Add a Product asset type and Product type taxonomy #787](https://github.com/farmOS/farmOS/pull/787)
- [Inventory quick form #766](https://github.com/farmOS/farmOS/pull/766)
- [Add UI for creating instances of quick forms #785](https://github.com/farmOS/farmOS/pull/785)
- [Show map on /locations #779](https://github.com/farmOS/farmOS/pull/779)
- [Provide a plan_record entity type for plan record relationships with metadata #781](https://github.com/farmOS/farmOS/pull/781)

### Changed

- [Recommend running composer update twice #653](https://github.com/farmOS/farmOS/pull/786)
- [Edit form UI improvements #770](https://github.com/farmOS/farmOS/pull/770)
- [Improve asset and log CSV exports #783](https://github.com/farmOS/farmOS/pull/783)
- [Remove "All" from "Items per page" options in Views #776](https://github.com/farmOS/farmOS/pull/776)

## [3.0.1] 2024-01-18

### Added

- [Add min/max options to integer fields in farm_field.factory #768](https://github.com/farmOS/farmOS/pull/768)

### Changed

- Allow users with asset view access to see /asset/%id/locations.

### Fixed

- [Patch drupal/core to fix Issue #3414883: datetime_timestamp widget does not use default field value #771](https://github.com/farmOS/farmOS/pull/771)
- [Fix duplicated revision tab on entities #773](https://github.com/farmOS/farmOS/pull/773)
- Improve access checking on location hierarchy forms.

## [3.0.0] 2024-01-05

This is the first "stable" release of farmOS v3. See the release notes for
[3.0.0-beta1] below for more information about major changes in the 3.x branch,
including breaking changes to be aware of.

### Changed

- [Increase weight of Asset and Log tasks on canonical user route #757](https://github.com/farmOS/farmOS/pull/757)
- [Update Drupal core to 10.2](https://github.com/farmOS/farmOS/pull/765)

### Deprecated

- [Issue #3410701: Deprecate d7_asset plugin](https://www.drupal.org/project/farm/issues/3410701)

### Fixed

- [Correct alter hook to add password grant to static scopes #755](https://github.com/farmOS/farmOS/pull/755)
- [Use strict identical operator when checking geometry format #756](https://github.com/farmOS/farmOS/pull/756)

## [3.0.0-beta3] 2023-11-27

### Fixed

- [Fix KML serialization #753](https://github.com/farmOS/farmOS/pull/753)

## [3.0.0-beta2] 2023-11-03

### Fixed

- Fixed 3.0.0-betaX tagged release packaging of tarballs and Docker images.
- [Update csv_serialization dependency to ^4.0 #745](https://github.com/farmOS/farmOS/pull/745)
- [Fix warning message when rendering link to birth log #746](https://github.com/farmOS/farmOS/pull/746)

## [3.0.0-beta1] 2023-11-01

This is the first release of the farmOS 3.x branch, following
[semantic versioning](https://semver.org/). This means changes have been made which may be
incompatible with existing integrations. These "breaking" changes are described
below, with links to specific issues/pull requests for more details.

farmOS v3 updates Drupal to version 10. Drupal 9 is end-of-life as of
[November 1st, 2023](https://www.drupal.org/docs/understanding-drupal/drupal-9-release-date-and-what-it-means/how-long-will-drupal-9-be-supported).
If you have built any add-on modules for farmOS, you will need to check that
they are compatible with Drupal 10, and declare support in your `*.info.yml`
file by changing `core_version_requirement` from `^9` to `^9 || ^10` (to
indicate that it works on both versions), or just `^10` (to indicate that it
only works on Drupal 10). The PHPStan tool that is included with the farmOS
`3.x-dev` Docker image can be used to perform static analysis of your module
code to see if there are deprecations that need to be fixed. See
[farmOS coding standards](https://farmos.org/development/environment/code/) for
more information.

If you are using PostgreSQL, Drupal 10 requires PostgreSQL version 12 or
greater, with the `pg_trgm` extension enabled. If you have PostgreSQL 13 or
greater, the `pg_trgm` extension will be enabled automatically during farmOS
installation. PostgreSQL 12 users, or users who are updating from farmOS 2.x to
3.x, will need to enable it manually by running the following query after the
farmOS database has been created, but before farmOS is installed/updated:
`CREATE EXTENSION pg_trgm;`

The [Simple OAuth](https://www.drupal.org/project/simple_oauth) module has been
updated to version 6. This includes a few breaking changes which may affect API
integrations. farmOS includes code to handle the transition of its own OAuth
clients and scopes, but if you have made any additional clients that used
special roles they will also need to be updated. The biggest changes are that
the "Implicit" grant type has been removed, and the "Password Credentials" grant
type has been moved to an optional "Simple OAuth Password Grant" module, which
must be enabled in order to use that grant type. The default farmOS client that
is included with farmOS has also been moved to a separate module that is not
enabled by default. After the update to farmOS 3.x, all access tokens will be
invalidated, but refresh tokens will still work to get a new access token.

farmOS 2.x included code to help migrate data from a farmOS 1.x database. This
code has been removed from farmOS 3.x If you are still on farmOS 1.x, you will
need to *migrate* to farmOS 2.x, and then *update* to farmOS 3.x. For more
information, see
[Migrating from farmOS v1](https://farmOS.org/hosting/migration/).

Lastly, the following deprecated functions/methods have been removed:

- `farm_log_asset_names_summary()`
- `QuickFormInterface::getId()`

### Changed

- [Issue #3382616: Remove v1 migrations from farmOS 3.x](https://www.drupal.org/project/farm/issues/3382616)
- [QuickFormInterface::getId() is replaced by QuickFormInterface::getQuickId()](https://www.drupal.org/node/3379686)
- [Remove deprecated farm_log_asset_names_summary()](https://www.drupal.org/node/3359456)
- [Issue #3394069: Update quantities to use bundle permission granularity](https://www.drupal.org/node/3394069)
- [Issue #3357679: Allow material quantities to reference multiple material types](https://www.drupal.org/project/farm/issues/3357679)
- [Issue #3330490: Update Drupal core to 10.x in farmOS](https://www.drupal.org/project/farm/issues/3330490)
- [Issue #3256745: Move default farm OAuth2 client to a separate module](https://www.drupal.org/project/farm/issues/3256745)
- [Update Simple OAuth module to v6 #743](https://github.com/farmOS/farmOS/pull/743)
- [Issue #3396419: Make log timestamp required](https://www.drupal.org/project/log/issues/3396419)
- Patch JSON:API Schema module for [Issue #3397275: Use OptionsProviderInterface::getPossibleOptions() for allowed field values (anyOf / oneOf)](https://www.drupal.org/project/jsonapi_schema/issues/3397275)

### Fixed

- [Issue #3197581: Cache needs to be cleared after setting MapBox API key for the first time](https://www.drupal.org/project/farm/issues/3197581)

## farmOS 2.x

farmOS 2.x release notes are available in the 2.x branch's
[CHANGELOG.md](https://github.com/farmOS/farmOS/blob/2.x/CHANGELOG.md)

## farmOS 1.x

farmOS 1.x release notes are available in the
[farmOS releases on Drupal.org](https://www.drupal.org/project/farm/releases?version=7.x-1).

[Unreleased]: https://github.com/farmOS/farmOS/compare/3.4.6...3.x
[3.4.6]: https://github.com/farmOS/farmOS/releases/tag/3.4.6
[3.4.5]: https://github.com/farmOS/farmOS/releases/tag/3.4.5
[3.4.4]: https://github.com/farmOS/farmOS/releases/tag/3.4.4
[3.4.3]: https://github.com/farmOS/farmOS/releases/tag/3.4.3
[3.4.2]: https://github.com/farmOS/farmOS/releases/tag/3.4.2
[3.4.1]: https://github.com/farmOS/farmOS/releases/tag/3.4.1
[3.4.0]: https://github.com/farmOS/farmOS/releases/tag/3.4.0
[3.3.3]: https://github.com/farmOS/farmOS/releases/tag/3.3.3
[3.3.2]: https://github.com/farmOS/farmOS/releases/tag/3.3.2
[3.3.1]: https://github.com/farmOS/farmOS/releases/tag/3.3.1
[3.3.0]: https://github.com/farmOS/farmOS/releases/tag/3.3.0
[3.2.4]: https://github.com/farmOS/farmOS/releases/tag/3.2.4
[3.2.3]: https://github.com/farmOS/farmOS/releases/tag/3.2.3
[3.2.2]: https://github.com/farmOS/farmOS/releases/tag/3.2.2
[3.2.1]: https://github.com/farmOS/farmOS/releases/tag/3.2.1
[3.2.0]: https://github.com/farmOS/farmOS/releases/tag/3.2.0
[3.1.2]: https://github.com/farmOS/farmOS/releases/tag/3.1.2
[3.1.1]: https://github.com/farmOS/farmOS/releases/tag/3.1.1
[3.1.0]: https://github.com/farmOS/farmOS/releases/tag/3.1.0
[3.0.1]: https://github.com/farmOS/farmOS/releases/tag/3.0.1
[3.0.0]: https://github.com/farmOS/farmOS/releases/tag/3.0.0
[3.0.0-beta3]: https://github.com/farmOS/farmOS/releases/tag/3.0.0-beta3
[3.0.0-beta2]: https://github.com/farmOS/farmOS/releases/tag/3.0.0-beta2
[3.0.0-beta1]: https://github.com/farmOS/farmOS/releases/tag/3.0.0-beta1
