<?php

declare(strict_types=1);

namespace Drupal\farm_calculation\Plugin\Log\LogType;

use Drupal\farm_entity\Plugin\Log\LogType\FarmLogType;

/**
 * Provides the calculation log type.
 *
 * @LogType(
 *   id = "calculation",
 *   label = @Translation("Calculation"),
 * )
 */
class Calculation extends FarmLogType {

  /**
   * {@inheritdoc}
   */
  public function buildFieldDefinitions() {
    $fields = parent::buildFieldDefinitions();

    // Calculation type.
    $options = [
      'type' => 'list_string',
      'label' => $this->t('Calculation type'),
      'allowed_values_function' => 'farm_calculation_type_field_allowed_values',
      'weight' => [
        'form' => -70,
        'view' => -70,
      ],
    ];
    $fields['calculation_type'] = $this->farmFieldFactory->bundleFieldDefinition($options);

    // Data sent.
    $options = [
      'type' => 'string_long',
      'label' => $this->t('Data sent'),
      'description' => $this->t('The input data sent to the calculator. This may be a JSON string or other structured data.'),
      'weight' => [
        'form' => -60,
        'view' => -60,
      ],
      'hidden' => 'form',
    ];
    $fields['data_sent'] = $this->farmFieldFactory->bundleFieldDefinition($options);

    // Data processed.
    $options = [
      'type' => 'string_long',
      'label' => $this->t('Data received'),
      'description' => $this->t('The output data received from the calculator. This may be a JSON string or other structured data.'),
      'weight' => [
        'form' => -50,
        'view' => -50,
      ],
      'hidden' => 'form',
    ];
    $fields['data_received'] = $this->farmFieldFactory->bundleFieldDefinition($options);

    // Metadata.
    $options = [
      'type' => 'string',
      'label' => $this->t('Metadata'),
      'description' => $this->t('Any additional metadata about the calculation, for example the version of the calculator used.'),
      'weight' => [
        'form' => -40,
        'view' => -40,
      ],
      'hidden' => 'form',
    ];
    $fields['metadata'] = $this->farmFieldFactory->bundleFieldDefinition($options);



    return $fields;
  }

}
