<?php

declare(strict_types=1);

namespace Drupal\farm_calculation\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;

/**
 * Defines the FarmCalculationType entity.
 *
 * @ConfigEntityType(
 *   id = "calculation_type",
 *   label = @Translation("Calculation type"),
 *   label_collection = @Translation("Calculation type"),
 *   handlers = { },
 *   admin_permission = "administer site configuration",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *   },
 * )
 *
 * @ingroup farm
 */
class FarmCalculationType extends ConfigEntityBase implements FarmCalculationTypeInterface {

  /**
   * The calculation type ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The calculation type label.
   *
   * @var string
   */
  protected $label;

  /**
   * {@inheritdoc}
   */
  public function getLabel() {
    return $this->label;
  }

}
