<?php

namespace Drupal\farm_multitenant\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Defines access logic for assets based on group membership.
 */
class AccessControlHandlerAsset extends AccessControlHandlerBase {

  /**
   * {@inheritdoc}
   */
  public function createAccess($entity_bundle = NULL, ?AccountInterface $account = NULL, array $context = [], $return_as_object = FALSE) {
    $account = $this->prepareUser($account);
    $permission = 'create ' . $entity_bundle . ' asset';
    if ($account && $account->hasPermission($permission)) {
      return $return_as_object ? AccessResult::allowed() : AccessResult::allowed()->isAllowed();
    }

    return parent::createAccess($entity_bundle, $account, $context, $return_as_object);
  }

  /**
   * {@inheritdoc}
   */
  protected function checkGroupAccess(EntityInterface $entity, AccountInterface $account) {
    // Ensure the entity is an asset.
    if ($entity->getEntityTypeId() !== 'asset') {
      return AccessResult::forbidden();
    }

    return parent::checkGroupAccess($entity, $account);
  }

}
