<?php

namespace Drupal\farm_multitenant\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Url;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Drupal\farm_multitenant\Service\OrganizationService;
use Drupal\group\Entity\GroupInterface;
use Drupal\organization\Entity\OrganizationInterface;

/**
 * Handles organization-related routes.
 */
class OrganizationController extends ControllerBase {

  /**
   * The organization helper service.
   *
   * @var \Drupal\farm_multitenant\Service\OrganizationService
   */
  protected $organizationHelper;

  /**
   * Constructs the controller.
   */
  public function __construct(OrganizationService $organization_service) {
    $this->organizationHelper = $organization_service;
  }

  /**
   * {@inheritdoc}
   */
  public static function create($container) {
    return new static($container->get('farm_multitenant.organization_service'));
  }

  /**
   * Redirects to the Add Member form for the related group.
   */
  public function addMember(OrganizationInterface $organization) {
    $group = $this->organizationHelper->getGroupFromOrganization($organization);

    if (!$group instanceof GroupInterface) {
      $this->messenger()->addError($this->t('The related group could not be found.'));
      return $this->redirect('entity.organization.canonical', ['organization' => $organization->id()]);
    }

    $destination = Url::fromRoute('farm_multitenant.organization.members', [
      'organization' => $organization->id(),
    ])->toString();

    $url = Url::fromRoute('entity.group_relationship.add_form', [
      'group' => $group->id(),
      'plugin_id' => 'group_membership',
    ], ['query' => ['destination' => $destination]]);

    return new RedirectResponse($url->toString());
  }

}
