# farmOS Multitenant

Supports multiple Farm tenants in a single farmOS installation. Leveraging the [Group module](https://www.drupal.org/project/group)
Farm Multitenant creates a group for each Farm Organization. A member of a Farm Organization can see assets, logs, and
other data for that organization only.

## Requirements
This module requires the following modules:

- [FarmOS](https://www.drupal.org/project/farm)
- [Group](https://www.drupal.org/project/group)

## Installation

Install as you would normally install a contributed Drupal module. Visit: [Installing Modules](https://www.drupal.org/docs/extending-drupal/installing-modules)
for further information.

A Drupal core patch is required for FarmOS installations using PostgreSQL. See:
- [#3523409: Error installing module: mimic_implicit_commit is already in use](https://www.drupal.org/project/farm_multitenant/issues/3523409)
- [#2920527: Postgres driver issue with nested savepoints mimic_implicit_commit duplicated](https://www.drupal.org/project/drupal/issues/2920527)

The module depends on the farm organization entity that is not currently in farmOS core and can be installed using this [PR](https://github.com/farmOS/farmOS/pull/849).

## Configuration
A group with type **Farm** will be created automatically for any existing farm organizations when the module is enabled. When
a new farm organization is created, a group will be created for that organization as well.

Members can be added to the farm organization group via the farmOS Setup pages (/organizations), as well as through the Group
module's configuration pages. This allows a site admin to hide the Group settings from farm managers to allow them to
manage their own members without having to know about groups.

## Roles and permissions
Configuring global and group roles for Farm Multitenant can be challenging, as it requires understanding both Drupal's 
permissions system and the Group module's roles and permissions. The module does not provide a default set of roles, apart from
the **Farm Admin** group role. To help with this, the module provides a recipe that can be applied to create an initial
set of roles and permissions for a typical Farm Multitenant installation.

### Roles Recipe
Example roles and permissions can be installed running the following command:

```
php core/scripts/drupal recipe modules/farm_multitenant/recipes/example_roles
```

For more information about Drupal recipes, see the [Recipes Initiative Documentation](https://project.pages.drupalcode.org/distributions_recipes/getting_started.html).

### Global Roles
The example global roles created by the recipe are:
- **Primary Manager**: This role can add and manage all farm organizations
- **Technical Assistance Provider Admin**: This role can create farm organizations and can view and manage organizations 
that they are a member of.
- **Technical Assistance Provider**: This role can can view and manage farm organizations that they are a member of, but
cannot create new farm organizations.
- **Producer**: This role can view, add and edit assets and logs that belong to the farm organization they are a member of.
- **Producer (read-only)**: This role can view assets and logs that belong to the farm organization they are a member of.

### Group Roles
The example group roles created by the recipe are:
- **Primary manager (outsider)** - This group role is mapped to the global **Primary Manager** role. It allows Primary managers
to manage farm organizations even if they are not a member of the organization.
- **Primary manager (insider)** - This group role is mapped to the global **Primary Manager** role. It allows Primary managers
who are members of an organization to retain the same permissions as the outsider role.
- **Technical Assistance Provider Admin** - This group role is mapped to the global **Technical Assistance Provider Admin** role.
It allows Technical Assistance Provider Admins to add farm organizations, and manage the members of the farm 
organizations it is a member of.
- **Technical Assistance Provider** - This group role is mapped to the global **Technical Assistance Provider** role. It allows
Technical Assistance Provider to manage the members of the farm organizations it is a member of.
- **Producer** - This group role is mapped to the global **Producer** role.
- **Producer (read-only)** - This group role is mapped to the global **Producer (read-only)** role.

## Sponsors
This project has been sponsored by:
* [Our Sci](https://www.our-sci.net/)
